
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=0, name="vitamin_C")
x1 = model.addVar(lb=0, name="vitamin_B2")
x2 = model.addVar(lb=0, name="magnesium")
x3 = model.addVar(lb=0, name="potassium")
x4 = model.addVar(lb=0, name="vitamin_B7")
x5 = model.addVar(lb=0, name="iron")

# Objective function
model.setObjective(7 * x0 * x1 + 8 * x0 * x2 + 8 * x0 * x4 + 9 * x0 * x5 + 
                   9 * x1 * x3 + x2 * x4 + 8 * x3 * x4 + 
                   7 * x4**2 + 7 * x5**2 + 2 * x0 + 5 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(x0 >= 1)
model.addConstr(x1 >= 7)
model.addConstr(x2 >= 16)
model.addConstr(x3 >= 26)
model.addConstr(x4 >= 24)
model.addConstr(x5 >= 13)

model.addConstr(19 * x0 <= 281)
model.addConstr(12 * x1 <= 281)
model.addConstr(25 * x2 <= 281)
model.addConstr(14 * x3 <= 281)
model.addConstr(24 * x4 <= 281)
model.addConstr(3 * x5 <= 281)

model.addConstr(17 * x0 <= 393)
model.addConstr(11 * x1 <= 393)
model.addConstr(11 * x2 <= 393)
model.addConstr(24 * x3 <= 393)
model.addConstr(16 * x4 <= 393)
model.addConstr(14 * x5 <= 393)

# Other constraints
model.addConstr(x1**2 + x2**2 >= 27)
model.addConstr(x2 + x4 >= 61)
model.addConstr(x0 + x3 >= 36)
model.addConstr(x4**2 + x5**2 >= 44)
model.addConstr(x0 + x1 + x2 + x3 + x4 + x5 >= 44)
model.addConstr(x0**2 + x2**2 >= 44)
model.addConstr(x1 + x5 >= 30)
model.addConstr(x0**2 + x5**2 >= 38)
model.addConstr(x4**2 + x5**2 >= 37)
model.addConstr(x3 + x4 >= 30)
model.addConstr(x2 + x5 >= 23)
model.addConstr(x1 + x2 + x5 >= 32)
model.addConstr(x1 + x3 + x5 >= 32)
model.addConstr(x0 + x1 + x4 >= 32)
model.addConstr(x0**2 + x2**2 + x3**2 >= 32)
model.addConstr(x0 + x2 + x5 >= 32)
model.addConstr(x1**2 + x2**2 + x5**2 >= 40)
model.addConstr(x1 + x3 + x5 >= 40)
model.addConstr(x0**2 + x1**2 + x4**2 >= 40)
model.addConstr(x0**2 + x2**2 + x3**2 >= 40)
model.addConstr(x0**2 + x2**2 + x5**2 >= 40)
model.addConstr(x1**2 + x2**2 + x5**2 >= 42)
model.addConstr(x1 + x3 + x5 >= 42)
model.addConstr(x0**2 + x1**2 + x4**2 >= 42)
model.addConstr(x0**2 + x2**2 + x3**2 >= 42)
model.addConstr(x0 + x2 + x5 >= 42)
model.addConstr(x1**2 + x2**2 + x5**2 >= 40)
model.addConstr(x1 + x3 + x5 >= 40)
model.addConstr(x0 + x1 + x4 >= 40)
model.addConstr(x0**2 + x3**2 + x5**2 >= 40)
model.addConstr(x0 + x1 + x2 + x3 + x4 + x5 >= 41)

model.addConstr(x1**2 + x3**2 >= 45)
model.addConstr(x4 + x5 >= 59)
model.addConstr(x1**2 + x4**2 + x5**2 >= 41)
model.addConstr(x3**2 + x4**2 + x5**2 >= 41)
model.addConstr(x0**2 + x1**2 + x5**2 >= 41)
model.addConstr(x1 + x2 + x5 >= 41)
model.addConstr(x0 + x1 + x4 >= 41)
model.addConstr(x1 + x2 + x3 >= 41)
model.addConstr(x1**2 + x2**2 + x4**2 >= 41)
model.addConstr(x0 + x3 + x5 >= 41)
model.addConstr(x0**2 + x2**2 + x5**2 >= 41)
model.addConstr(x0 + x1 + x2 + x3 + x4 + x5 >= 41)

model.addConstr(7 * x2**2 - x5**2 >= 0)
model.addConstr(-9 * x3 + 3 * x5 >= 0)

model.addConstr(x0 + x1 <= 194 / 1)
model.addConstr(x2**2 + x3**2 + x5**2 <= 356)
model.addConstr(x1 + x2 + x5 <= 123)
model.addConstr(x1 + x3 + x4 <= 288)
model.addConstr(x0**2 + x1**2 + x4**2 <= 273)
model.addConstr(x0 + x1 + x2 <= 79)
model.addConstr(x0**2 + x3**2 + x4**2 <= 378)
model.addConstr(x0 + x1 + x3 <= 255)
model.addConstr(x2 + x3 + x4 <= 76)

model.addConstr(x1**2 + x3**2 + x5**2 <= 133)
model.addConstr(x1 + x4 + x5 <= 79)
model.addConstr(x0**2 + x2**2 + x4**2 <= 351)
model.addConstr(x0**2 + x1**2 + x4**2 <= 145)
model.addConstr(x0**2 + x3**2 + x5**2 <= 352)
model.addConstr(x3**2 + x4**2 + x5**2 <= 278)
model.addConstr(x2 + x3 + x4 <= 353)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Vitamin C: ", x0.varValue)
    print("Vitamin B2: ", x1.varValue)
    print("Magnesium: ", x2.varValue)
    print("Potassium: ", x3.varValue)
    print("Vitamin B7: ", x4.varValue)
    print("Iron: ", x5.varValue)
else:
    print("No optimal solution found")
