
from gurobipy import Model, GRB

# Create a new model
model = Model("Productivity Optimization")

# Create variables
john = model.addVar(lb=0, name="John")
peggy = model.addVar(lb=0, name="Peggy")
paul = model.addVar(lb=0, name="Paul")
bobby = model.addVar(lb=0, name="Bobby")
mary = model.addVar(lb=0, name="Mary")
laura = model.addVar(lb=0, name="Laura")
jean = model.addVar(lb=0, name="Jean")

# Set objective function
model.setObjective(3*john*john + 4*peggy*mary + 3*paul*mary + 4*paul*laura + 7*bobby*laura + mary*laura + 3*bobby, GRB.MAXIMIZE)

# Add constraints
model.addConstr(-10*john*john + 10*peggy*peggy >= 0, "c1")
model.addConstr(29*bobby*bobby + 18*mary*mary <= 385, "c2")
model.addConstr(17*peggy*peggy + 22*jean*jean <= 449, "c3")
model.addConstr(17*peggy + 18*mary <= 432, "c4")
model.addConstr(17*peggy + 4*paul <= 855, "c5")
model.addConstr(17*peggy*peggy + 29*bobby*bobby <= 264, "c6")
model.addConstr(22*john*john + 18*mary*mary <= 364, "c7")
model.addConstr(18*mary + 15*laura <= 283, "c8")
model.addConstr(4*paul + 22*jean <= 363, "c9")
model.addConstr(4*paul + 18*mary <= 653, "c10")
model.addConstr(22*john + 15*laura <= 253, "c11")
model.addConstr(22*john + 4*paul <= 690, "c12")
model.addConstr(22*john + 17*peggy <= 300, "c13")
model.addConstr(22*john + 22*jean <= 279, "c14")
model.addConstr(18*mary*mary + 22*jean*jean <= 527, "c15")
model.addConstr(22*john + 29*bobby <= 199, "c16")
model.addConstr(22*john*john + 15*laura*laura + 22*jean*jean <= 571, "c17")
model.addConstr(17*peggy + 4*paul + 15*laura <= 527, "c18")
model.addConstr(22*john + 17*peggy + 22*jean <= 650, "c19")
model.addConstr(4*paul + 18*mary + 15*laura <= 862, "c20")
model.addConstr(29*bobby + 15*laura + 22*jean <= 881, "c21")
model.addConstr(22*john + 17*peggy + 15*laura <= 561, "c22")
model.addConstr(17*peggy + 4*paul + 18*mary <= 817, "c23")
model.addConstr(22*john + 4*paul + 15*laura <= 402, "c24")
model.addConstr(17*peggy + 29*bobby + 22*jean <= 698, "c25")
model.addConstr(22*john + 29*bobby + 22*jean <= 380, "c26")
model.addConstr(4*paul + 29*bobby + 18*mary <= 824, "c27")
model.addConstr(29*bobby + 18*mary + 15*laura <= 699, "c28")
model.addConstr(17*peggy + 29*bobby + 18*mary <= 271, "c29")
model.addConstr(4*paul + 29*bobby + 22*jean <= 899, "c30")
model.addConstr(4*paul + 29*bobby + 15*laura <= 199, "c31")
model.addConstr(22*john + 4*paul + 29*bobby <= 225, "c32")
model.addConstr(22*john + 17*peggy + 4*paul + 29*bobby + 18*mary + 15*laura + 22*jean <= 225, "c33")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

