
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
J = m.addVar(name="hours_worked_by_John", lb=-gp.GRB.INFINITY)
P = m.addVar(name="hours_worked_by_Peggy", lb=-gp.GRB.INFINITY)
L = m.addVar(name="hours_worked_by_Paul", lb=-gp.GRB.INFINITY)
B = m.addVar(name="hours_worked_by_Bobby", lb=-gp.GRB.INFINITY)
M = m.addVar(name="hours_worked_by_Mary", lb=-gp.GRB.INFINITY)
LA = m.addVar(name="hours_worked_by_Laura", lb=-gp.GRB.INFINITY)
JE = m.addVar(name="hours_worked_by_Jean", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(3*J**2 + 4*P*M + 3*L*M + 4*L*LA + 7*B*LA + M*LA + 3*B, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(-10*J**2 + 10*P**2 >= 0)
m.addConstr(B**2 + M**2 <= 385)
m.addConstr(P**2 + JE**2 <= 449)
m.addConstr(P + M <= 432)
m.addConstr(P + L <= 855)
m.addConstr(P**2 + B**2 <= 264)
m.addConstr(J**2 + M**2 <= 364)
m.addConstr(M + LA <= 283)
m.addConstr(L + JE <= 363)
m.addConstr(L + M <= 653)
m.addConstr(J + LA <= 253)
m.addConstr(J + L <= 690)
m.addConstr(J + P <= 300)
m.addConstr(J + JE <= 279)
m.addConstr(M**2 + JE**2 <= 527)
m.addConstr(J + B <= 199)
m.addConstr(J**2 + LA**2 + JE**2 <= 571)
m.addConstr(P + L + LA <= 527)
m.addConstr(J + P + JE <= 650)
m.addConstr(L + M + LA <= 862)
m.addConstr(B + LA + JE <= 881)
m.addConstr(J + P + LA <= 561)
m.addConstr(P + L + M <= 817)
m.addConstr(J + L + LA <= 402)
m.addConstr(P + B + JE <= 698)
m.addConstr(J + B + JE <= 380)
m.addConstr(L + B + M <= 824)
m.addConstr(B + M + LA <= 699)
m.addConstr(P + B + M <= 271)
m.addConstr(L + B + JE <= 899)
m.addConstr(L + B + LA <= 199)
m.addConstr(J + L + B <= 225)
m.addConstr(J + P + L + B + M + LA + JE <= 225)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Peggy: ", P.varValue)
    print("Hours worked by Paul: ", L.varValue)
    print("Hours worked by Bobby: ", B.varValue)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Laura: ", LA.varValue)
    print("Hours worked by Jean: ", JE.varValue)
else:
    print("The model is infeasible")
