
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
pickles = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
oreos = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Set objective function
model.setObjective(6.69 * pickles**2 + 1.02 * oreos**2 + 7.54 * pickles + 3.56 * oreos, GRB.MINIMIZE)

# Add constraints
model.addConstr(16 * pickles + 1 * oreos >= 26, "iron_constraint1")
model.addConstr(3 * pickles**2 + 10 * oreos**2 >= 31, "calcium_constraint1")
model.addConstr(3 * pickles + 10 * oreos >= 31, "calcium_constraint2")
model.addConstr(20 * pickles + 21 * oreos >= 8, "carbohydrate_constraint1")
model.addConstr(7 * pickles - 7 * oreos >= 0, "custom_constraint1")
model.addConstr(16 * pickles**2 + 1 * oreos**2 <= 57, "iron_constraint2")
model.addConstr(3 * pickles + 10 * oreos <= 73, "calcium_constraint3")
model.addConstr(20 * pickles + 21 * oreos <= 33, "carbohydrate_constraint2")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found: pickles = {pickles.x}, oreos = {oreos.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

