
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
pickles = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
oreos = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Objective function
m.setObjective(6.69 * pickles**2 + 1.02 * oreos**2 + 7.54 * pickles + 3.56 * oreos, GRB.MINIMIZE)

# Constraints
m.addConstr(16*pickles + 1*oreos >= 26, name="iron_constraint")
m.addConstr(3*pickles + 10*oreos >= 31, name="calcium_min_constraint")
m.addConstr(20*pickles + 21*oreos >= 8, name="carbohydrates_min_constraint")
m.addConstr(7*pickles - 7*oreos >= 0, name="linear_constraint")
m.addConstr(16*pickles + 1*oreos <= 57, name="iron_max_constraint")
m.addConstr(3*pickles + 10*oreos <= 73, name="calcium_max_constraint")
m.addConstr(20*pickles + 21*oreos <= 33, name="carbohydrates_max_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pickles: {pickles.x}")
    print(f"Oreos: {oreos.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
