
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    pickles = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="pickles")
    oreos = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="oreos")

    # Objective function
    model.setObjective(6.69 * pickles**2 + 1.02 * oreos**2 + 7.54 * pickles + 3.56 * oreos, gurobi.GRB.MINIMIZE)

    # Constraints
    # Iron content constraints
    model.addConstr(16 * pickles + oreos >= 26, name="iron_min")
    model.addConstr(16 * pickles + oreos <= 57, name="iron_max")

    # Calcium content constraints
    model.addConstr(3 * pickles + 10 * oreos >= 31, name="calcium_min")
    model.addConstr(3 * pickles + 10 * oreos <= 73, name="calcium_max")

    # Carbohydrates content constraints
    model.addConstr(20 * pickles + 21 * oreos >= 8, name="carbohydrates_min")
    model.addConstr(20 * pickles + 21 * oreos <= 33, name="carbohydrates_max")

    # Additional constraint
    model.addConstr(7 * pickles - 7 * oreos >= 0, name="balance")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("Pickles: ", pickles.x)
        print("Oreos: ", oreos.x)
    else:
        print("No optimal solution found")

optimization_problem()
