
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_a")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")

# Set objective function
m.setObjective(3.78 * vitamin_c + 3.66 * vitamin_a + 3.88 * vitamin_b7, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * vitamin_c + 3 * vitamin_a >= 12, "kidney_support_c_a_min")
m.addConstr(4 * vitamin_a + 7 * vitamin_b7 >= 35, "muscle_growth_a_b7_min")
m.addConstr(3 * vitamin_a + 3 * vitamin_b7 <= 48, "kidney_support_a_b7_max")
m.addConstr(2 * vitamin_c + 3 * vitamin_a <= 35, "kidney_support_c_a_max")
m.addConstr(2 * vitamin_c + 3 * vitamin_a + 3 * vitamin_b7 <= 35, "kidney_support_c_a_b7_max")
m.addConstr(1 * vitamin_c + 4 * vitamin_a <= 112, "muscle_growth_c_a_max")
m.addConstr(1 * vitamin_c + 7 * vitamin_b7 <= 79, "muscle_growth_c_b7_max")
m.addConstr(1 * vitamin_c + 4 * vitamin_a + 7 * vitamin_b7 <= 79, "muscle_growth_c_a_b7_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_c:', vitamin_c.x)
    print('vitamin_a:', vitamin_a.x)
    print('vitamin_b7:', vitamin_b7.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

