
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_C", vtype=GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_A", vtype=GRB.INTEGER)
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B7", vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(3.78*x0 + 3.66*x1 + 3.88*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 3*x1 >= 12, name="kidney_support_index_1")
m.addConstr(4*x1 + 7*x2 >= 35, name="muscle_growth_index_1")
m.addConstr(3*x1 + 3*x2 <= 48, name="kidney_support_index_2")
m.addConstr(2*x0 + 3*x1 <= 35, name="kidney_support_index_3")
m.addConstr(2*x0 + 3*x1 + 3*x2 <= 35, name="total_kidney_support_index")
m.addConstr(x0 + 4*x1 <= 112, name="muscle_growth_index_2")
m.addConstr(x0 + 7*x2 <= 79, name="muscle_growth_index_3")
m.addConstr(x0 + 4*x1 + 7*x2 <= 79, name="total_muscle_growth_index")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin C: {x0.x}")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Milligrams of Vitamin B7: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
