
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
sashimi = m.addVar(type=GRB.CONTINUOUS, name="sashimi")
pasta = m.addVar(type=GRB.INTEGER, name="bowls_of_pasta")
knishes = m.addVar(type=GRB.INTEGER, name="knishes")
hamburgers = m.addVar(type=GRB.INTEGER, name="hamburgers")
chicken_thighs = m.addVar(type=GRB.CONTINUOUS, name="chicken_thighs")

# Set objective function
m.setObjective(7.13 * sashimi**2 + 5.11 * sashimi * pasta + 8.45 * sashimi * hamburgers + 2.82 * pasta * knishes + 3.6 * pasta * hamburgers + 8.6 * pasta * chicken_thighs + 9.18 * knishes**2 + 5.24 * knishes * hamburgers + 7.54 * hamburgers + 2.54 * chicken_thighs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * sashimi + 15 * knishes + 7 * chicken_thighs >= 58)
m.addConstr(9 * sashimi + 19 * pasta + 7 * chicken_thighs >= 58)
m.addConstr(19 * pasta**2 + 15 * knishes**2 + 7 * chicken_thighs**2 >= 58)
m.addConstr(9 * sashimi + 15 * knishes + 7 * chicken_thighs >= 60)
m.addConstr(9 * sashimi + 19 * pasta + 7 * chicken_thighs >= 60)
m.addConstr(19 * pasta + 15 * knishes + 7 * chicken_thighs >= 60)
m.addConstr(9 * sashimi + 15 * knishes + 7 * chicken_thighs >= 51)
m.addConstr(9 * sashimi + 19 * pasta + 7 * chicken_thighs >= 51)
m.addConstr(19 * pasta + 15 * knishes + 7 * chicken_thighs >= 51)

m.addConstr(7 * sashimi + 13 * chicken_thighs >= 92)
m.addConstr(7 * sashimi + 17 * hamburgers >= 71)
m.addConstr(4 * knishes**2 + 13 * chicken_thighs**2 >= 102)
m.addConstr(14 * pasta**2 + 4 * knishes**2 >= 50)
m.addConstr(7 * sashimi**2 + 4 * knishes**2 >= 138)
m.addConstr(17 * hamburgers**2 + 13 * chicken_thighs**2 >= 69)

m.addConstr(7 * pasta + 16 * hamburgers >= 37)
m.addConstr(7 * pasta + 18 * chicken_thighs >= 35)
m.addConstr(17 * sashimi + 16 * hamburgers >= 26)
m.addConstr(16 * hamburgers + 18 * chicken_thighs >= 17)
m.addConstr(17 * sashimi**2 + 12 * knishes**2 >= 21)
m.addConstr(12 * knishes + 16 * hamburgers >= 25)
m.addConstr(7 * pasta + 12 * knishes + 16 * hamburgers >= 25)
m.addConstr(17 * sashimi + 7 * pasta + 12 * knishes >= 25)
m.addConstr(17 * sashimi + 12 * knishes + 18 * chicken_thighs >= 25)
m.addConstr(12 * knishes + 16 * hamburgers + 18 * chicken_thighs >= 25)
m.addConstr(17 * sashimi + 12 * knishes + 16 * hamburgers >= 25)
m.addConstr(17 * sashimi**2 + 7 * pasta**2 + 16 * hamburgers**2 >= 25)
m.addConstr(7 * pasta**2 + 12 * knishes**2 + 18 * chicken_thighs**2 >= 25)


# ... (rest of the constraints)


# Resource constraints
m.addConstr(9 * sashimi + 19 * pasta + 15 * knishes + 13 * hamburgers + 7 * chicken_thighs <= 316, "r0")
m.addConstr(7 * sashimi + 14 * pasta + 4 * knishes + 17 * hamburgers + 13 * chicken_thighs <= 709, "r1")
m.addConstr(17 * sashimi + 7 * pasta + 12 * knishes + 16 * hamburgers + 18 * chicken_thighs <= 201, "r2")
m.addConstr(22 * sashimi + 21 * pasta + 15 * knishes + 18 * hamburgers + 4 * chicken_thighs <= 416, "r3")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

