
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Objective function: Minimize 2*x0 + 6*x1
m.setObjective(2*x0 + 6*x1, GRB.MINIMIZE)

# Constraints:
# 1. security engineers each cause 4 milliseconds of additional network latency.
#    intrusion analysts create 23 milliseconds in additional network latency each.
#    Combined latency should be at least 80 ms and no more than 134 ms.
m.addConstr(4*x0 + 23*x1 >= 80, "min_latency")
m.addConstr(4*x0 + 23*x1 <= 134, "max_latency")

# 2. security engineers cost 13 dollars each. intrusion analysts are $13 each.
#    Spend at least $72 on both and no more than $190.
m.addConstr(13*x0 + 13*x1 >= 72, "min_cost")
m.addConstr(13*x0 + 13*x1 <= 190, "max_cost")

# 3. 1 times the number of security engineers, plus -1 times the number of intrusion analysts should be greater than or equal to zero.
m.addConstr(x0 - x1 >= 0, "security_vs_intrusion")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Security Engineers: {x0.x}")
    print(f"Intrusion Analysts: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
