
import gurobipy as gp

# Create a new model
m = gp.Model("security_engineers_intrusion_analysts")

# Define the variables
security_engineers = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)
intrusion_analysts = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)

# Objective function: Minimize 2 * security engineers + 6 * intrusion analysts
m.setObjective(2 * security_engineers + 6 * intrusion_analysts, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4 * security_engineers + 23 * intrusion_analysts >= 80, name="min_latency")
m.addConstr(13 * security_engineers + 13 * intrusion_analysts >= 72, name="min_cost")
m.addConstr(security_engineers - intrusion_analysts >= 0, name="security_engineers_vs_intrusion_analysts")
m.addConstr(4 * security_engineers + 23 * intrusion_analysts <= 134, name="max_latency")
m.addConstr(13 * security_engineers + 13 * intrusion_analysts <= 198, name="max_cost")

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Security Engineers: {security_engineers.varValue}")
    print(f"Intrusion Analysts: {intrusion_analysts.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
