
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")
calcium = model.addVar(lb=0, vtype=GRB.INTEGER, name="calcium")
vitamin_b3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b3")
vitamin_b5 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b5")

# Set objective function
model.setObjective(7 * vitamin_b1 + 5 * calcium + 8 * vitamin_b3 + 8 * vitamin_b5, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * vitamin_b1 + 3 * calcium + 11 * vitamin_b3 + 11 * vitamin_b5 <= 125, "c0") # Cognitive performance index upper bound
model.addConstr(1 * vitamin_b1 + 8 * calcium + 3 * vitamin_b3 + 5 * vitamin_b5 <= 67, "c1") # Digestive support index upper bound

model.addConstr(11 * vitamin_b3 + 11 * vitamin_b5 >= 16, "c2")
model.addConstr(8 * vitamin_b1 + 11 * vitamin_b5 >= 24, "c3")
model.addConstr(8 * vitamin_b1 + 3 * calcium + 11 * vitamin_b3 + 11 * vitamin_b5 >= 24, "c4")
model.addConstr(8 * calcium + 3 * vitamin_b3 >= 16, "c5")
model.addConstr(1 * vitamin_b1 + 8 * calcium + 3 * vitamin_b3 + 5 * vitamin_b5 >= 16, "c6")

model.addConstr(-8 * calcium + 10 * vitamin_b5 >= 0, "c7")
model.addConstr(-3 * vitamin_b3 + 6 * vitamin_b5 >= 0, "c8")
model.addConstr(-6 * calcium + 4 * vitamin_b3 + 6 * vitamin_b5 >= 0, "c9")

model.addConstr(8 * vitamin_b1 + 11 * vitamin_b3 + 11 * vitamin_b5 <= 98, "c10")
model.addConstr(1 * vitamin_b1 + 8 * calcium <= 23, "c11")
model.addConstr(8 * calcium + 5 * vitamin_b5 <= 27, "c12")
model.addConstr(3 * vitamin_b3 + 5 * vitamin_b5 <= 40, "c13")
model.addConstr(1 * vitamin_b1 + 5 * vitamin_b5 <= 48, "c14")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('vitamin_b1:', vitamin_b1.x)
    print('calcium:', calcium.x)
    print('vitamin_b3:', vitamin_b3.x)
    print('vitamin_b5:', vitamin_b5.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

