
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B1")  # continuous
    x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="calcium")  # integer
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B3")  # continuous
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B5")  # continuous

    # Objective function
    model.setObjective(7 * x0 + 5 * x1 + 8 * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    # Cognitive performance index constraints
    model.addConstr(8 * x0 + 3 * x1 + 11 * x2 + 11 * x3 >= 24, name="cognitive_total")
    model.addConstr(11 * x2 + 11 * x3 >= 16, name="cognitive_B3_B5")
    model.addConstr(8 * x0 + 11 * x3 >= 24, name="cognitive_B1_B5")
    model.addConstr(8 * x0 + 3 * x1 + 11 * x2 + 11 * x3 <= 98, name="cognitive_max")

    # Digestive support index constraints
    model.addConstr(x0 + 8 * x1 + 3 * x2 + 5 * x3 >= 16, name="digestive_total")
    model.addConstr(8 * x1 + 3 * x2 >= 16, name="digestive_calcium_B3")
    model.addConstr(x0 + 8 * x1 <= 23, name="digestive_B1_calcium")
    model.addConstr(8 * x1 + 5 * x3 <= 27, name="digestive_calcium_B5")
    model.addConstr(3 * x2 + 5 * x3 <= 40, name="digestive_B3_B5")
    model.addConstr(x0 + 5 * x3 <= 48, name="digestive_B1_B5")

    # Linear constraints
    model.addConstr(-8 * x1 + 10 * x3 >= 0, name="linear1")
    model.addConstr(-3 * x2 + 6 * x3 >= 0, name="linear2")
    model.addConstr(-6 * x1 + 4 * x2 + 6 * x3 >= 0, name="linear3")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Vitamin B1: ", x0.varValue)
        print("Calcium: ", x1.varValue)
        print("Vitamin B3: ", x2.varValue)
        print("Vitamin B5: ", x3.varValue)
    else:
        print("No optimal solution found")

optimize_vitamins()
