
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
peanutbutter_sandwiches = m.addVar(lb=0, name="peanutbutter_sandwiches")
milkshakes = m.addVar(lb=0, name="milkshakes")

# Set objective function
m.setObjective(5 * peanutbutter_sandwiches**2 + 9 * peanutbutter_sandwiches * milkshakes + 3 * milkshakes**2 + 6 * peanutbutter_sandwiches + 4 * milkshakes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.83 * peanutbutter_sandwiches**2 + 0.68 * milkshakes**2 >= 55, "fiber_constraint1")
m.addConstr(0.83 * peanutbutter_sandwiches + 0.68 * milkshakes >= 55, "fiber_constraint2")
m.addConstr(6.28 * peanutbutter_sandwiches + 10.37 * milkshakes >= 18, "tastiness_constraint1")
m.addConstr(6.28 * peanutbutter_sandwiches + 10.37 * milkshakes <= 73, "tastiness_constraint2")
m.addConstr(3 * peanutbutter_sandwiches - milkshakes >= 0, "constraint5")
m.addConstr(0.83 * peanutbutter_sandwiches + 0.68 * milkshakes <= 100, "fiber_constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('milkshakes:', milkshakes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

