
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milkshakes")

# Objective function
m.setObjective(5*x0**2 + 9*x0*x1 + 3*x1**2 + 6*x0 + 4*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(0.83*x0 + 0.68*x1 <= 143, name="fiber_constraint")
m.addConstr(6.28*x0 + 10.37*x1 >= 18, name="tastiness_min")
m.addConstr(6.28*x0 + 10.37*x1 <= 73, name="tastiness_max")
m.addConstr(0.83*x0 + 0.68*x1 >= 55, name="min_fiber")
m.addConstr((0.83**2)*x0**2 + (0.68**2)*x1**2 >= 55**2, name="min_fiber_squared")
m.addConstr(3*x0 - x1 >= 0, name="linear_constraint")
m.addConstr(0.83*x0 + 0.68*x1 <= 100, name="max_fiber")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"peanutbutter_sandwiches: {x0.x}")
    print(f"milkshakes: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
