
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="peanutbutter_sandwiches", lb=0)  # Non-negative
    x1 = model.addVar(name="milkshakes", lb=0)  # Non-negative

    # Objective function
    model.setObjective(5*x0**2 + 9*x0*x1 + 3*x1**2 + 6*x0 + 4*x1, gurobi.GRB.MINIMIZE)

    # Constraints
    # Fiber content constraints
    model.addConstr(0.83*x0 + 0.68*x1 >= 55, name="min_fiber")
    model.addConstr(0.83*x0 + 0.68*x1 <= 100, name="max_fiber")

    # Tastiness rating constraints
    model.addConstr(6.28*x0 + 10.37*x1 >= 18, name="min_tastiness")
    model.addConstr(6.28*x0 + 10.37*x1 <= 73, name="max_tastiness")

    # Other constraints
    model.addConstr(3*x0 - x1 >= 0, name="ratio_constraint")

    # Solve the problem
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peanut butter sandwiches: {x0.varValue}")
        print(f"Milkshakes: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is: ", model.status)

optimize_problem()
