
import gurobipy as gp

# Create a new model
m = gp.Model("office_supplies")

# Create variables
paper = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="yellow_highlighters")
punches = m.addVar(vtype=gp.GRB.INTEGER, name="hole_punches")
pens = m.addVar(vtype=gp.GRB.INTEGER, name="black_pens")

# Set objective function
m.setObjective(6.04 * paper + 7.53 * highlighters + 4.52 * punches + 6.92 * pens, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * paper + 1 * highlighters + 12 * punches + 29 * pens <= 637, "dollar_cost")  # r0
m.addConstr(12 * paper + 12 * highlighters + 2 * punches + 24 * pens <= 517, "sustainability_score")  # r1

m.addConstr(12 * highlighters + 2 * punches + 24 * pens >= 103, "sustainability_1")
m.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 103, "sustainability_2")
m.addConstr(12 * paper + 12 * highlighters + 2 * punches >= 103, "sustainability_3")
m.addConstr(12 * paper + 2 * punches + 24 * pens >= 103, "sustainability_4")

m.addConstr(12 * highlighters + 2 * punches + 24 * pens >= 75, "sustainability_5")
m.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 75, "sustainability_6")
m.addConstr(12 * paper + 12 * highlighters + 2 * punches >= 75, "sustainability_7")
m.addConstr(12 * paper + 2 * punches + 24 * pens >= 75, "sustainability_8")

m.addConstr(12 * highlighters + 2 * punches + 24 * pens >= 102, "sustainability_9")
m.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 102, "sustainability_10")
m.addConstr(12 * paper + 12 * highlighters + 2 * punches >= 102, "sustainability_11")
m.addConstr(12 * paper + 2 * punches + 24 * pens >= 102, "sustainability_12")

m.addConstr(12 * highlighters + 2 * punches + 24 * pens >= 91, "sustainability_13")
m.addConstr(12 * paper + 12 * highlighters + 24 * pens >= 91, "sustainability_14")
m.addConstr(12 * paper + 12 * highlighters + 2 * punches >= 91, "sustainability_15")
m.addConstr(12 * paper + 2 * punches + 24 * pens >= 91, "sustainability_16")


m.addConstr(25 * paper + 12 * punches <= 203, "cost_1")
m.addConstr(25 * paper + 29 * pens <= 229, "cost_2")
m.addConstr(1 * highlighters + 12 * punches <= 527, "cost_3")
m.addConstr(25 * paper + 1 * highlighters <= 552, "cost_4")
m.addConstr(1 * highlighters + 29 * pens <= 374, "cost_5")
m.addConstr(25 * paper + 12 * punches + 29 * pens <= 465, "cost_6")
m.addConstr(1 * highlighters + 12 * punches + 29 * pens <= 193, "cost_7")
m.addConstr(25 * paper + 1 * highlighters + 12 * punches + 29 * pens <= 193, "cost_8")

m.addConstr(2 * punches + 24 * pens <= 495, "sustainability_17")
m.addConstr(12 * highlighters + 2 * punches <= 509, "sustainability_18")
m.addConstr(12 * paper + 2 * punches <= 208, "sustainability_19")
m.addConstr(12 * highlighters + 2 * punches + 24 * pens <= 179, "sustainability_20")
m.addConstr(12 * paper + 12 * highlighters + 2 * punches + 24 * pens <= 179, "sustainability_21")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

