
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
packs_of_paper = m.addVar(vtype=gurobi.GRB.INTEGER, name="packs_of_paper", lb=0)
yellow_highlighters = m.addVar(vtype=gurobi.GRB.INTEGER, name="yellow_highlighters", lb=0)
hole_punches = m.addVar(vtype=gurobi.GRB.INTEGER, name="hole_punches", lb=0)
black_pens = m.addVar(vtype=gurobi.GRB.INTEGER, name="black_pens", lb=0)

# Set the value of packs of paper
packs_of_paper.Set(25)

# Define the objective function
m.setObjective(6.04 * packs_of_paper + 7.53 * yellow_highlighters + 4.52 * hole_punches + 6.92 * black_pens, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * yellow_highlighters + 12 * hole_punches + 24 * black_pens >= 103, name="c1")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 24 * black_pens >= 103, name="c2")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 2 * hole_punches >= 103, name="c3")
m.addConstr(12 * packs_of_paper + 2 * hole_punches + 24 * black_pens >= 103, name="c4")
m.addConstr(12 * yellow_highlighters + 2 * hole_punches + 24 * black_pens >= 75, name="c5")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 24 * black_pens >= 75, name="c6")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 2 * hole_punches >= 75, name="c7")
m.addConstr(12 * packs_of_paper + 2 * hole_punches + 24 * black_pens >= 75, name="c8")
m.addConstr(12 * yellow_highlighters + 2 * hole_punches + 24 * black_pens >= 102, name="c9")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 24 * black_pens >= 102, name="c10")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 2 * hole_punches >= 102, name="c11")
m.addConstr(12 * packs_of_paper + 2 * hole_punches + 24 * black_pens >= 102, name="c12")
m.addConstr(12 * yellow_highlighters + 2 * hole_punches + 24 * black_pens >= 91, name="c13")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 24 * black_pens >= 91, name="c14")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 2 * hole_punches >= 91, name="c15")
m.addConstr(12 * packs_of_paper + 2 * hole_punches + 24 * black_pens >= 91, name="c16")
m.addConstr(25 * packs_of_paper + 12 * hole_punches <= 203, name="c17")
m.addConstr(25 * packs_of_paper + 29 * black_pens <= 229, name="c18")
m.addConstr(1 * yellow_highlighters + 12 * hole_punches <= 527, name="c19")
m.addConstr(25 * packs_of_paper + 1 * yellow_highlighters <= 552, name="c20")
m.addConstr(1 * yellow_highlighters + 29 * black_pens <= 374, name="c21")
m.addConstr(25 * packs_of_paper + 12 * hole_punches + 29 * black_pens <= 465, name="c22")
m.addConstr(1 * yellow_highlighters + 12 * hole_punches + 29 * black_pens <= 193, name="c23")
m.addConstr(25 * packs_of_paper + 1 * yellow_highlighters + 12 * hole_punches + 29 * black_pens <= 193, name="c24")
m.addConstr(2 * hole_punches + 24 * black_pens <= 495, name="c25")
m.addConstr(12 * yellow_highlighters + 2 * hole_punches <= 509, name="c26")
m.addConstr(12 * packs_of_paper + 2 * hole_punches <= 208, name="c27")
m.addConstr(12 * yellow_highlighters + 2 * hole_punches + 24 * black_pens <= 179, name="c28")
m.addConstr(12 * packs_of_paper + 12 * yellow_highlighters + 2 * hole_punches + 24 * black_pens <= 179, name="c29")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("packs of paper: ", packs_of_paper.varValue)
    print("yellow highlighters: ", yellow_highlighters.varValue)
    print("hole punches: ", hole_punches.varValue)
    print("black pens: ", black_pens.varValue)
else:
    print("The model is infeasible")
