
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks")
potatoes = m.addVar(lb=0, name="potatoes")
bananas = m.addVar(lb=0, name="bananas")
granola_bars = m.addVar(lb=0, name="granola_bars")
chicken_breasts = m.addVar(lb=0, name="chicken_breasts")

# Set objective function
m.setObjective(2 * chicken_drumsticks + 9 * potatoes + 9 * bananas + 5 * granola_bars + 2 * chicken_breasts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * chicken_drumsticks + 5 * potatoes + 10 * bananas + 11 * granola_bars + 9 * chicken_breasts <= 234, "protein_constraint") #r0
m.addConstr(2 * chicken_drumsticks + 14 * potatoes + 14 * bananas + 6 * granola_bars + 2 * chicken_breasts <= 166, "tastiness_constraint") #r1
m.addConstr(2 * chicken_drumsticks + 14 * bananas >= 32, "tastiness_drumsticks_bananas")
m.addConstr(14 * bananas + 6 * granola_bars >= 23, "tastiness_bananas_granola")
m.addConstr(14 * potatoes + 2 * chicken_breasts >= 30, "tastiness_potatoes_chicken_breasts")
m.addConstr(14 * potatoes + 6 * granola_bars >= 32, "tastiness_potatoes_granola")
m.addConstr(14 * potatoes + 14 * bananas >= 32, "tastiness_potatoes_bananas")
m.addConstr(2 * chicken_drumsticks + 14 * potatoes >= 21, "tastiness_drumsticks_potatoes")
m.addConstr(14 * potatoes + 6 * granola_bars + 2 * chicken_breasts >= 26, "tastiness_potatoes_granola_chicken_breasts")
m.addConstr(2 * chicken_drumsticks + 14 * potatoes + 6 * granola_bars >= 26, "tastiness_drumsticks_potatoes_granola")
m.addConstr(14 * potatoes + 6 * granola_bars + 2 * chicken_breasts >= 24, "tastiness_potatoes_granola_chicken_breasts_2")
m.addConstr(2 * chicken_drumsticks + 14 * potatoes + 6 * granola_bars >= 24, "tastiness_drumsticks_potatoes_granola_2")
m.addConstr(4 * chicken_drumsticks + 10 * bananas + 11 * granola_bars <= 159, "protein_drumsticks_bananas_granola")
m.addConstr(4 * chicken_drumsticks + 5 * potatoes + 11 * granola_bars <= 182, "protein_drumsticks_potatoes_granola")
m.addConstr(4 * chicken_drumsticks + 5 * potatoes + 10 * bananas <= 59, "protein_drumsticks_potatoes_bananas")
m.addConstr(4 * chicken_drumsticks + 5 * potatoes + 10 * bananas + 11 * granola_bars + 9 * chicken_breasts <= 59, "protein_all")
m.addConstr(14 * potatoes + 6 * granola_bars <= 79, "tastiness_potatoes_granola_max")
m.addConstr(2 * chicken_drumsticks + 2 * chicken_breasts <= 63, "tastiness_drumsticks_chicken_breasts_max")
m.addConstr(14 * bananas + 6 * granola_bars <= 33, "tastiness_bananas_granola_max")
m.addConstr(14 * potatoes + 2 * chicken_breasts <= 122, "tastiness_potatoes_chicken_breasts_max")
m.addConstr(6 * granola_bars + 2 * chicken_breasts <= 36, "tastiness_granola_chicken_breasts_max")
m.addConstr(2 * chicken_drumsticks + 6 * granola_bars <= 163, "tastiness_drumsticks_granola_max")
m.addConstr(2 * chicken_drumsticks + 14 * potatoes + 14 * bananas + 6 * granola_bars + 2 * chicken_breasts <= 163, "tastiness_all_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

