
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
dale_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Dale_Hours")
peggy_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Peggy_Hours")
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="George_Hours")
bobby_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Bobby_Hours")

# Set objective function
model.setObjective(4.89 * dale_hours + 2.71 * peggy_hours + 2.84 * george_hours + 2.81 * bobby_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2.77 * george_hours + 1.19 * bobby_hours >= 36, "c1")
model.addConstr(6.87 * peggy_hours + 1.19 * bobby_hours >= 40, "c2")
model.addConstr(7.93 * george_hours + 12.05 * bobby_hours >= 14, "c3")
model.addConstr(1.32 * dale_hours + 6.87 * peggy_hours >= 19, "c4")
model.addConstr(2.77 * george_hours + 1.19 * bobby_hours <= 109, "c5")
model.addConstr(6.87 * peggy_hours + 2.77 * george_hours <= 70, "c6")
model.addConstr(6.87 * peggy_hours + 2.77 * george_hours + 1.19 * bobby_hours <= 157, "c7")
model.addConstr(1.32 * dale_hours + 2.77 * george_hours + 1.19 * bobby_hours <= 72, "c8")
model.addConstr(1.32 * dale_hours + 6.87 * peggy_hours + 2.77 * george_hours + 1.19 * bobby_hours <= 72, "c9")
model.addConstr(7.93 * george_hours + 12.05 * bobby_hours <= 134, "c10")
model.addConstr(3.76 * dale_hours + 9.8 * peggy_hours <= 70, "c11")
model.addConstr(3.76 * dale_hours + 12.05 * bobby_hours <= 113, "c12")
model.addConstr(9.8 * peggy_hours + 12.05 * bobby_hours <= 138, "c13")
model.addConstr(3.76 * dale_hours + 9.8 * peggy_hours + 12.05 * bobby_hours <= 142, "c14")
model.addConstr(9.8 * peggy_hours + 7.93 * george_hours + 12.05 * bobby_hours <= 84, "c15")
model.addConstr(3.76 * dale_hours + 9.8 * peggy_hours + 7.93 * george_hours <= 57, "c16")
model.addConstr(3.76 * dale_hours + 9.8 * peggy_hours + 7.93 * george_hours + 12.05 * bobby_hours <= 57, "c17")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dale Hours: {dale_hours.x}")
    print(f"Peggy Hours: {peggy_hours.x}")
    print(f"George Hours: {george_hours.x}")
    print(f"Bobby Hours: {bobby_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

