
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Bobby

    # Objective function
    model.setObjective(4.89 * x0 + 2.71 * x1 + 2.84 * x2 + 2.81 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.77 * x2 + 1.19 * x3 >= 36)
    model.addConstr(6.87 * x1 + 1.19 * x3 >= 40)
    model.addConstr(7.93 * x2 + 12.05 * x3 >= 14)
    model.addConstr(3.76 * x0 + 9.8 * x1 >= 19)
    model.addConstr(2.77 * x2 + 1.19 * x3 <= 109)
    model.addConstr(6.87 * x1 + 2.77 * x2 <= 70)
    model.addConstr(6.87 * x1 + 2.77 * x2 + 1.19 * x3 <= 157)
    model.addConstr(1.32 * x0 + 2.77 * x2 + 1.19 * x3 <= 72)
    model.addConstr(1.32 * x0 + 6.87 * x1 + 2.77 * x2 + 1.19 * x3 <= 72)
    model.addConstr(7.93 * x2 + 12.05 * x3 <= 134)
    model.addConstr(3.76 * x0 + 9.8 * x1 <= 70)
    model.addConstr(3.76 * x0 + 12.05 * x3 <= 113)
    model.addConstr(9.8 * x1 + 12.05 * x3 <= 138)
    model.addConstr(3.76 * x0 + 9.8 * x1 + 12.05 * x3 <= 142)
    model.addConstr(9.8 * x1 + 7.93 * x2 + 12.05 * x3 <= 84)
    model.addConstr(3.76 * x0 + 9.8 * x1 + 7.93 * x2 <= 57)
    model.addConstr(3.76 * x0 + 9.8 * x1 + 7.93 * x2 + 12.05 * x3 <= 57)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x0.varValue}")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by George: {x2.varValue}")
        print(f"Hours worked by Bobby: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
