
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
J = m.addVar(name="J", lb=0)  # hours worked by John
E = m.addVar(name="E", lb=0, integrality=1)  # hours worked by Jean
M = m.addVar(name="M", lb=0, integrality=1)  # hours worked by Mary
P = m.addVar(name="P", lb=0, integrality=1)  # hours worked by Peggy
B = m.addVar(name="B", lb=0, integrality=1)  # hours worked by Bill
R = m.addVar(name="R", lb=0, integrality=1)  # hours worked by Ringo

# Define the objective function
m.setObjective(6.84 * J + 9.37 * E + 6.19 * M + 5.75 * P + 9.17 * B + 6.6 * R, gp.GRB.MAXIMIZE)

# Add constraints
# Paperwork competence rating constraints
m.addConstr(6 * J <= 243)
m.addConstr(3 * E <= 243)
m.addConstr(5 * M <= 243)
m.addConstr(2 * P <= 243)
m.addConstr(4 * B <= 243)
m.addConstr(3 * R <= 243)

# Work quality rating constraints
m.addConstr(3 * J <= 179)
m.addConstr(9 * E <= 179)
m.addConstr(M <= 179)
m.addConstr(9 * P <= 179)
m.addConstr(4 * B <= 179)
m.addConstr(11 * R <= 179)

# Combined rating constraints
m.addConstr(2 * P + 3 * R >= 17)
m.addConstr(6 * J + 3 * R >= 26)
m.addConstr(6 * J + 4 * B >= 38)
m.addConstr(3 * E + 3 * R >= 36)
m.addConstr(6 * J + 3 * E >= 28)
m.addConstr(2 * P + 4 * B >= 32)
m.addConstr(3 * E + 5 * M + 2 * P >= 32)
m.addConstr(6 * J + 4 * B + 3 * R >= 32)
m.addConstr(3 * E + M + 2 * P >= 38)
m.addConstr(6 * J + 4 * B + 3 * R >= 38)

# ... (add all constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {J.varValue}")
    print(f"Hours worked by Jean: {E.varValue}")
    print(f"Hours worked by Mary: {M.varValue}")
    print(f"Hours worked by Peggy: {P.varValue}")
    print(f"Hours worked by Bill: {B.varValue}")
    print(f"Hours worked by Ringo: {R.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
