
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="carbohydrates")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")

# Set objective function
m.setObjective(9.5 * vitamin_b6 + 6.83 * carbohydrates + 8.19 * fat + 3.52 * iron, gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 15 * fat + 4 * iron <= 169, "r0_upper_bound")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates + 35 * fat + 15 * iron <= 283, "r1_upper_bound")


# Combined energy stability index constraints
m.addConstr(27 * carbohydrates + 15 * fat >= 14, "c1")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates >= 36, "c2")
m.addConstr(15 * fat + 4 * iron >= 36, "c3")
m.addConstr(27 * carbohydrates + 4 * iron >= 39, "c4")
m.addConstr(35 * vitamin_b6 + 4 * iron >= 29, "c5")
m.addConstr(35 * vitamin_b6 + 15 * fat >= 14, "c6")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 4 * iron >= 28, "c7")
m.addConstr(27 * carbohydrates + 15 * fat + 4 * iron >= 28, "c8")
m.addConstr(35 * vitamin_b6 + 15 * fat + 4 * iron >= 28, "c9")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 4 * iron >= 37, "c10")
m.addConstr(27 * carbohydrates + 15 * fat + 4 * iron >= 37, "c11")
m.addConstr(35 * vitamin_b6 + 15 * fat + 4 * iron >= 37, "c12")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 4 * iron >= 41, "c13")
m.addConstr(27 * carbohydrates + 15 * fat + 4 * iron >= 41, "c14")
m.addConstr(35 * vitamin_b6 + 15 * fat + 4 * iron >= 41, "c15")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 15 * fat + 4 * iron >= 41, "c16")

# Combined immune support index constraints
m.addConstr(26 * vitamin_b6 + 15 * iron >= 27, "c17")
m.addConstr(29 * carbohydrates + 15 * iron >= 57, "c18")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates >= 46, "c19")
m.addConstr(26 * vitamin_b6 + 35 * fat >= 62, "c20")
m.addConstr(29 * carbohydrates + 35 * fat + 15 * iron >= 48, "c21")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates + 15 * iron >= 48, "c22")
m.addConstr(29 * carbohydrates + 35 * fat + 15 * iron >= 45, "c23")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates + 15 * iron >= 45, "c24")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates + 35 * fat + 15 * iron >= 45, "c25")


# Upper bound constraints
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates <= 63, "c26")
m.addConstr(27 * carbohydrates + 15 * fat + 4 * iron <= 139, "c27")
m.addConstr(35 * vitamin_b6 + 27 * carbohydrates + 4 * iron <= 63, "c28")
m.addConstr(26 * vitamin_b6 + 15 * iron <= 152, "c29")
m.addConstr(26 * vitamin_b6 + 35 * fat <= 281, "c30")
m.addConstr(29 * carbohydrates + 35 * fat <= 161, "c31")
m.addConstr(29 * carbohydrates + 15 * iron <= 276, "c32")
m.addConstr(26 * vitamin_b6 + 29 * carbohydrates <= 182, "c33")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

