
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="milligrams of vitamin B6")  # vitamin B6
x1 = m.addVar(lb=0, integrality=1, name="grams of carbohydrates")  # carbohydrates
x2 = m.addVar(lb=0, name="grams of fat")  # fat
x3 = m.addVar(lb=0, name="milligrams of iron")  # iron

# Define the objective function
m.setObjective(9.5 * x0 + 6.83 * x1 + 8.19 * x2 + 3.52 * x3, GRB.MINIMIZE)

# Add the energy stability index constraints
m.addConstr(35 * x0 + 27 * x1 + 15 * x2 + 4 * x3 <= 169, name="energy_stability_index")
m.addConstr(27 * x1 + 15 * x2 >= 14, name="energy_stability_index_1")
m.addConstr(35 * x0 + 27 * x1 >= 36, name="energy_stability_index_2")
m.addConstr(15 * x2 + 4 * x3 >= 36, name="energy_stability_index_3")
m.addConstr(27 * x1 + 4 * x3 >= 39, name="energy_stability_index_4")
m.addConstr(35 * x0 + 4 * x3 >= 29, name="energy_stability_index_5")
m.addConstr(35 * x0 + 15 * x2 >= 14, name="energy_stability_index_6")
m.addConstr(35 * x0 + 27 * x1 + 4 * x3 >= 28, name="energy_stability_index_7")
m.addConstr(27 * x1 + 15 * x2 + 4 * x3 >= 28, name="energy_stability_index_8")
m.addConstr(35 * x0 + 15 * x2 + 4 * x3 >= 28, name="energy_stability_index_9")
m.addConstr(35 * x0 + 27 * x1 + 4 * x3 >= 37, name="energy_stability_index_10")
m.addConstr(27 * x1 + 15 * x2 + 4 * x3 >= 37, name="energy_stability_index_11")
m.addConstr(35 * x0 + 15 * x2 + 4 * x3 >= 37, name="energy_stability_index_12")
m.addConstr(35 * x0 + 27 * x1 + 4 * x3 >= 41, name="energy_stability_index_13")
m.addConstr(27 * x1 + 15 * x2 + 4 * x3 >= 41, name="energy_stability_index_14")
m.addConstr(35 * x0 + 15 * x2 + 4 * x3 >= 41, name="energy_stability_index_15")
m.addConstr(35 * x0 + 27 * x1 + 15 * x2 + 4 * x3 >= 41, name="energy_stability_index_16")

# Add the immune support index constraints
m.addConstr(26 * x0 + 15 * x3 >= 27, name="immune_support_index_1")
m.addConstr(29 * x1 + 15 * x3 >= 57, name="immune_support_index_2")
m.addConstr(26 * x0 + 29 * x1 >= 46, name="immune_support_index_3")
m.addConstr(26 * x0 + 35 * x2 >= 62, name="immune_support_index_4")
m.addConstr(29 * x1 + 35 * x2 + 15 * x3 >= 48, name="immune_support_index_5")
m.addConstr(26 * x0 + 29 * x1 + 15 * x3 >= 48, name="immune_support_index_6")
m.addConstr(29 * x1 + 35 * x2 + 15 * x3 >= 45, name="immune_support_index_7")
m.addConstr(26 * x0 + 29 * x1 + 15 * x3 >= 45, name="immune_support_index_8")
m.addConstr(26 * x0 + 29 * x1 + 35 * x2 + 15 * x3 >= 45, name="immune_support_index_9")

# Add the upper bound constraints
m.addConstr(35 * x0 + 27 * x1 <= 63, name="upper_bound_1")
m.addConstr(27 * x1 + 15 * x2 + 4 * x3 <= 139, name="upper_bound_2")
m.addConstr(35 * x0 + 27 * x1 + 4 * x3 <= 63, name="upper_bound_3")
m.addConstr(26 * x0 + 15 * x3 <= 152, name="upper_bound_4")
m.addConstr(26 * x0 + 35 * x2 <= 281, name="upper_bound_5")
m.addConstr(29 * x1 + 35 * x2 <= 161, name="upper_bound_6")
m.addConstr(29 * x1 + 15 * x3 <= 276, name="upper_bound_7")
m.addConstr(26 * x0 + 29 * x1 <= 182, name="upper_bound_8")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Milligrams of vitamin B6: ", x0.varValue)
    print("Grams of carbohydrates: ", x1.varValue)
    print("Grams of fat: ", x2.varValue)
    print("Milligrams of iron: ", x3.varValue)
else:
    print("The model is infeasible")
