
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
    bill = model.addVar(vtype=gp.GRB.INTEGER, name="bill")
    mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
    dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")
    ringo = model.addVar(vtype=gp.GRB.CONTINUOUS, name="ringo")
    bobby = model.addVar(vtype=gp.GRB.INTEGER, name="bobby")
    peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")

    # Set objective function
    model.setObjective(5*jean + 6*bill + 2*mary + 8*dale + 1*ringo + 7*bobby + 7*peggy, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(dale + bobby >= 17/1.0)
    model.addConstr(dale + peggy >= 37/1.0)
    model.addConstr(dale + ringo >= 16/1.0)
    model.addConstr(jean + peggy >= 28/1.0)
    model.addConstr(ringo + peggy >= 16/1.0)
    model.addConstr(bill + bobby >= 22/1.0)
    model.addConstr(jean + dale >= 42/1.0)
    model.addConstr(jean + bobby >= 24/1.0)
    model.addConstr(jean + mary >= 24/1.0)
    model.addConstr(bill + dale + ringo >= 27/1.0)
    model.addConstr(jean + bobby + peggy >= 27/1.0)
    model.addConstr(bill + dale + ringo >= 31/1.0)
    model.addConstr(jean + bobby + peggy >= 31/1.0)
    model.addConstr(4*jean + 10*bill + 2*mary + 1*dale + 5*ringo + 14*bobby + 1*peggy >= 31)
    model.addConstr(-5*bill + peggy >= 0)
    model.addConstr(10*bill + 5*ringo <= 302)
    model.addConstr(dale + ringo <= 242/1.0)
    model.addConstr(4*jean + 5*ringo <= 72)
    model.addConstr(10*bill + 14*bobby <= 70)
    model.addConstr(10*bill + peggy <= 139)
    model.addConstr(2*mary + 5*ringo <= 62)
    model.addConstr(2*mary + dale <= 61/1.0)
    model.addConstr(2*mary + peggy <= 217)
    model.addConstr(4*jean + dale <= 152/1.0)
    model.addConstr(4*jean + 10*bill <= 151)
    model.addConstr(14*bobby + peggy <= 227)
    model.addConstr(10*bill + dale <= 195/1.0)
    model.addConstr(4*jean + 2*mary <= 98)
    model.addConstr(5*ringo + peggy <= 274)
    model.addConstr(5*ringo + 14*bobby + peggy <= 306)
    model.addConstr(4*jean + 14*bobby + peggy <= 300)
    model.addConstr(10*bill + dale + 14*bobby <= 97/1.0)
    model.addConstr(4*jean + dale + 14*bobby <= 251/1.0)
    model.addConstr(dale + ringo + peggy <= 167/1.0)
    model.addConstr(10*bill + 2*mary + 5*ringo <= 227)
    model.addConstr(10*bill + 2*mary + peggy <= 252)
    model.addConstr(dale + 14*bobby + peggy <= 159/1.0)
    model.addConstr(2*mary + dale + 5*ringo <= 78/1.0)
    model.addConstr(4*jean + 10*bill + 5*ringo <= 298)
    model.addConstr(2*mary + 5*ringo + 14*bobby <= 139)
    model.addConstr(10*bill + 5*ringo + peggy <= 279)
    model.addConstr(2*mary + dale + 14*bobby <= 161/1.0)
    model.addConstr(4*jean + 2*mary + peggy <= 54)
    model.addConstr(4*jean + 2*mary + 14*bobby <= 52)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
