
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
john = model.addVar(vtype=GRB.INTEGER, name="john")
dale = model.addVar(vtype=GRB.INTEGER, name="dale")
mary = model.addVar(vtype=GRB.INTEGER, name="mary")
paul = model.addVar(vtype=GRB.INTEGER, name="paul")
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")

# Set objective function
model.setObjective(6*john*john + john*paul + 5*john*ringo + 9*paul*ringo + paul, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15*dale + paul + 9*ringo >= 52, "c1")
model.addConstr(15*dale*dale + 26*mary*mary + 9*ringo*ringo >= 52, "c2")
model.addConstr(28*john + 26*mary + paul >= 52, "c3")
model.addConstr(28*john + 15*dale + 26*mary >= 52, "c4")
model.addConstr(28*john + paul + 9*ringo >= 52, "c5")
model.addConstr(26*mary*mary + paul*paul + 9*ringo*ringo >= 52, "c6")
model.addConstr(15*dale + 26*mary + paul >= 52, "c7")
model.addConstr(28*john + 15*dale + 9*ringo >= 52, "c8")
model.addConstr(15*dale + paul + 9*ringo >= 44, "c9")
model.addConstr(15*dale + 26*mary + 9*ringo >= 44, "c10")
model.addConstr(28*john*john + 26*mary*mary + paul*paul >= 44, "c11")
model.addConstr(28*john + 15*dale + 26*mary >= 44, "c12")
model.addConstr(28*john + paul + 9*ringo >= 44, "c13")
model.addConstr(26*mary + paul + 9*ringo >= 44, "c14")
model.addConstr(15*dale + 26*mary + paul >= 44, "c15")
model.addConstr(28*john + 15*dale + 9*ringo >= 44, "c16")
model.addConstr(15*dale + paul + 9*ringo >= 36, "c17")
model.addConstr(15*dale + 26*mary + 9*ringo >= 36, "c18")
model.addConstr(28*john*john + 26*mary*mary + paul*paul >= 36, "c19")
model.addConstr(28*john + 15*dale + 26*mary >= 36, "c20")
model.addConstr(28*john + paul + 9*ringo >= 36, "c21")
model.addConstr(26*mary + paul + 9*ringo >= 36, "c22")
model.addConstr(15*dale*dale + 26*mary*mary + paul*paul >= 36, "c23")
model.addConstr(28*john + 15*dale + 9*ringo >= 36, "c24")
model.addConstr(15*dale + paul + 9*ringo >= 68, "c25")
model.addConstr(15*dale + 26*mary + 9*ringo >= 68, "c26")
model.addConstr(28*john + 26*mary + paul >= 68, "c27")
model.addConstr(28*john*john + 15*dale*dale + 26*mary*mary >= 68, "c28")
model.addConstr(28*john + paul + 9*ringo >= 68, "c29")
model.addConstr(26*mary + paul + 9*ringo >= 68, "c30")
model.addConstr(15*dale + 26*mary + paul >= 68, "c31")
model.addConstr(28*john + 15*dale + 9*ringo >= 68, "c32")
model.addConstr(15*dale + paul + 9*ringo >= 51, "c33")
model.addConstr(15*dale*dale + 26*mary*mary + 9*ringo*ringo >= 51, "c34")
model.addConstr(28*john + 26*mary + paul >= 51, "c35")
model.addConstr(28*john + 15*dale + 26*mary >= 51, "c36")
model.addConstr(28*john + paul + 9*ringo >= 51, "c37")
model.addConstr(26*mary*mary + paul*paul + 9*ringo*ringo >= 51, "c38")
model.addConstr(15*dale + 26*mary + paul >= 51, "c39")
model.addConstr(28*john + 15*dale + 9*ringo >= 51, "c40")
model.addConstr(15*dale*dale + paul*paul + 9*ringo*ringo >= 41, "c41")
model.addConstr(15*dale*dale + 26*mary*mary + 9*ringo*ringo >= 41, "c42")
model.addConstr(28*john + 26*mary + paul >= 41, "c43")
model.addConstr(28*john + 15*dale + 26*mary >= 41, "c44")
model.addConstr(28*john + paul + 9*ringo >= 41, "c45")
model.addConstr(26*mary + paul + 9*ringo >= 41, "c46")
model.addConstr(15*dale + 26*mary + paul >= 41, "c47")
model.addConstr(28*john + 15*dale + 9*ringo >= 41, "c48")
model.addConstr(15*dale + paul + 9*ringo >= 48, "c49")
model.addConstr(15*dale*dale + 26*mary*mary + 9*ringo*ringo >= 48, "c50")
model.addConstr(28*john*john + 26*mary*mary + paul*paul >= 48, "c51")
model.addConstr(28*john + 15*dale + 26*mary >= 48, "c52")
model.addConstr(28*john + paul + 9*ringo >= 48, "c53")
model.addConstr(26*mary + paul + 9*ringo >= 48, "c54")

model.addConstr(15*dale*dale + 26*mary*mary + paul*paul >= 48, "c55")
model.addConstr(28*john + 15*dale + 9*ringo >= 48, "c56")
model.addConstr(15*dale*dale + paul*paul + 9*ringo*ringo >= 50, "c57")
model.addConstr(15*dale + 26*mary + 9*ringo >= 50, "c58")
model.addConstr(28*john + 26*mary + paul >= 50, "c59")
model.addConstr(28*john*john + 15*dale*dale + 26*mary*mary >= 50, "c60")
model.addConstr(28*john + paul + 9*ringo >= 50, "c61")
model.addConstr(26*mary*mary + paul*paul + 9*ringo*ringo >= 50, "c62")
model.addConstr(15*dale + 26*mary + paul >= 50, "c63")
model.addConstr(28*john + 15*dale + 9*ringo >= 50, "c64")


model.addConstr(-4*john + 4*ringo >= 0, "c65")
model.addConstr(28*john + 26*mary <= 210, "c66")
model.addConstr(28*john + paul <= 296, "c67")
model.addConstr(28*john + 15*dale <= 229, "c68")
model.addConstr(15*dale + 26*mary <= 79, "c69")
model.addConstr(26*mary + 9*ringo <= 331, "c70")
model.addConstr(28*john*john + 9*ringo*ringo <= 134, "c71")
model.addConstr(15*dale + paul <= 339, "c72")
model.addConstr(26*mary + paul <= 298, "c73")
model.addConstr(26*mary*mary + paul*paul + 9*ringo*ringo <= 202, "c74")
model.addConstr(28*john + 15*dale + 26*mary + paul + 9*ringo <= 202, "c75")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
