
import gurobi as gp

def create_model():
    model = gp.Model("optimization_problem")

    J = model.addVar(name="hours_worked_by_John", vtype=gp.GRB.INTEGER)
    D = model.addVar(name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
    M = model.addVar(name="hours_worked_by_Mary", vtype=gp.GRB.INTEGER)
    P = model.addVar(name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)
    R = model.addVar(name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)

    ratings = {'J': 28, 'D': 15, 'M': 26, 'P': 1, 'R': 9}

    model.setObjective(6 * J**2 + J * P + 5 * J * R + 9 * P * R + P, gp.GRB.MAXIMIZE)

    # Example constraints
    model.addConstr(J == ratings['J'])
    model.addConstr(D == ratings['D'])
    model.addConstr(M == ratings['M'])
    model.addConstr(P == ratings['P'])
    model.addConstr(R == ratings['R'])

    # Adding a sample constraint for demonstration
    model.addConstr(D + P + R >= 52)

    return model, J, D, M, P, R

model, J, D, M, P, R = create_model()
model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Dale: ", D.varValue)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Paul: ", P.varValue)
    print("Hours worked by Ringo: ", R.varValue)
else:
    print("No optimal solution found")
