
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")

# Set objective function
m.setObjective(8.33 * kale_salads + 8.71 * potatoes + 9.53 * blueberry_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * kale_salads + 12 * potatoes >= 22, "calcium_constraint1")
m.addConstr(12 * potatoes + 6 * blueberry_pies >= 17, "calcium_constraint2")
m.addConstr(1 * kale_salads + 12 * potatoes + 6 * blueberry_pies <= 31, "calcium_constraint3") # Combined constraint for calcium upper bound

m.addConstr(3 * kale_salads + 3 * blueberry_pies >= 24, "umami_constraint1")
m.addConstr(3 * kale_salads + 3 * blueberry_pies <= 120, "umami_constraint2")
m.addConstr(3 * kale_salads + 6 * potatoes <= 130, "umami_constraint3")
m.addConstr(3 * kale_salads + 6 * potatoes + 3 * blueberry_pies <= 130, "umami_constraint4")


m.addConstr(10 * potatoes + 13 * blueberry_pies >= 57, "carbohydrate_constraint1")
m.addConstr(2 * kale_salads + 13 * blueberry_pies >= 56, "carbohydrate_constraint2")
m.addConstr(2 * kale_salads + 13 * blueberry_pies <= 92, "carbohydrate_constraint3")
m.addConstr(2 * kale_salads + 10 * potatoes <= 146, "carbohydrate_constraint4")
m.addConstr(10 * potatoes + 13 * blueberry_pies <= 69, "carbohydrate_constraint5")
m.addConstr(2 * kale_salads + 10 * potatoes + 13 * blueberry_pies <= 69, "carbohydrate_constraint6")


m.addConstr(10 * kale_salads + 14 * blueberry_pies >= 59, "iron_constraint1")
m.addConstr(8 * potatoes + 14 * blueberry_pies >= 41, "iron_constraint2")
m.addConstr(10 * kale_salads + 8 * potatoes <= 117, "iron_constraint3")
m.addConstr(10 * kale_salads + 8 * potatoes + 14 * blueberry_pies <= 117, "iron_constraint4")

m.addConstr(-3 * kale_salads + 7 * blueberry_pies >= 0, "constraint7")
m.addConstr(12 * potatoes + 6 * blueberry_pies <= 79, "constraint8")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

