
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")

# Set objective function
m.setObjective(2.65 * eggs + 6.12 * strawberries + 5.16 * tomatoes + 8.03 * peanutbutter_sandwiches, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 146, "calcium_upper_bound") #r0
m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 90, "healthiness_upper_bound") #r1

m.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches >= 13, "calcium_tomatoes_peanutbutter")
m.addConstr(3 * strawberries + 12 * tomatoes >= 31, "calcium_strawberries_tomatoes")
m.addConstr(4 * eggs + 3 * peanutbutter_sandwiches >= 35, "calcium_eggs_peanutbutter")

m.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 18, "healthiness_eggs_strawberries_peanutbutter_1") #redundant
m.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 18, "healthiness_strawberries_tomatoes_peanutbutter_1") #redundant
m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 18, "healthiness_eggs_strawberries_tomatoes_1") #redundant
m.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 13, "healthiness_eggs_strawberries_peanutbutter_2")
m.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 13, "healthiness_strawberries_tomatoes_peanutbutter_2")
m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 13, "healthiness_eggs_strawberries_tomatoes_2")
m.addConstr(6 * eggs + 11 * strawberries + 14 * peanutbutter_sandwiches >= 13, "healthiness_eggs_strawberries_peanutbutter_3") #redundant
m.addConstr(11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches >= 13, "healthiness_strawberries_tomatoes_peanutbutter_3") #redundant
m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes >= 13, "healthiness_eggs_strawberries_tomatoes_3") #redundant


m.addConstr(12 * tomatoes + 3 * peanutbutter_sandwiches <= 84, "calcium_tomatoes_peanutbutter_upper")
m.addConstr(4 * eggs + 3 * strawberries <= 101, "calcium_eggs_strawberries_upper")
m.addConstr(4 * eggs + 3 * peanutbutter_sandwiches <= 116, "calcium_eggs_peanutbutter_upper")
m.addConstr(4 * eggs + 12 * tomatoes <= 47, "calcium_eggs_tomatoes_upper")
m.addConstr(3 * strawberries + 3 * peanutbutter_sandwiches <= 59, "calcium_strawberries_peanutbutter_upper")
m.addConstr(3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 128, "calcium_strawberries_tomatoes_peanutbutter_upper")
m.addConstr(4 * eggs + 3 * strawberries + 3 * peanutbutter_sandwiches <= 122, "calcium_eggs_strawberries_peanutbutter_upper")
m.addConstr(4 * eggs + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120, "calcium_eggs_tomatoes_peanutbutter_upper")
m.addConstr(4 * eggs + 3 * strawberries + 12 * tomatoes + 3 * peanutbutter_sandwiches <= 120, "calcium_all_upper")

m.addConstr(6 * eggs + 14 * peanutbutter_sandwiches <= 69, "healthiness_eggs_peanutbutter_upper")
m.addConstr(11 * strawberries + 14 * tomatoes <= 36, "healthiness_strawberries_tomatoes_upper")
m.addConstr(6 * eggs + 11 * strawberries <= 38, "healthiness_eggs_strawberries_upper")
m.addConstr(6 * eggs + 11 * strawberries + 14 * tomatoes + 14 * peanutbutter_sandwiches <= 38, "healthiness_all_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

