
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Hour_Optimization")

# Create variables
hank_hours = m.addVar(lb=0, name="hank_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")

# Set objective function
m.setObjective(7 * hank_hours + 4 * paul_hours + 8 * dale_hours + 5 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18 * hank_hours + 8 * dale_hours + 2 * mary_hours >= 105)
m.addConstr(18 * hank_hours + 25 * paul_hours + 2 * mary_hours >= 105)
m.addConstr(18 * hank_hours + 25 * paul_hours + 8 * dale_hours >= 105)
m.addConstr(18 * hank_hours + 8 * dale_hours + 2 * mary_hours >= 54)
m.addConstr(18 * hank_hours + 25 * paul_hours + 2 * mary_hours >= 54)
m.addConstr(18 * hank_hours + 25 * paul_hours + 8 * dale_hours >= 54)
m.addConstr(18 * hank_hours + 8 * dale_hours + 2 * mary_hours >= 95)
m.addConstr(18 * hank_hours + 25 * paul_hours + 2 * mary_hours >= 95)
m.addConstr(18 * hank_hours + 25 * paul_hours + 8 * dale_hours >= 95)

m.addConstr(17 * hank_hours + 4 * dale_hours >= 72)
m.addConstr(17 * hank_hours + 7 * mary_hours >= 82)
m.addConstr(26 * paul_hours + 4 * dale_hours >= 92)
m.addConstr(17 * hank_hours + 26 * paul_hours >= 48)
m.addConstr(17 * hank_hours + 26 * paul_hours + 7 * mary_hours >= 82)

m.addConstr(10 * hank_hours + 9 * paul_hours + 21 * dale_hours >= 46)
m.addConstr(10 * hank_hours + 21 * dale_hours + 10 * mary_hours >= 46)
m.addConstr(10 * hank_hours + 9 * paul_hours + 10 * mary_hours >= 46)
m.addConstr(10 * hank_hours + 9 * paul_hours + 21 * dale_hours >= 74)
m.addConstr(10 * hank_hours + 21 * dale_hours + 10 * mary_hours >= 74)
m.addConstr(10 * hank_hours + 9 * paul_hours + 10 * mary_hours >= 74)
m.addConstr(10 * hank_hours + 9 * paul_hours + 21 * dale_hours >= 44)
m.addConstr(10 * hank_hours + 21 * dale_hours + 10 * mary_hours >= 44)
m.addConstr(10 * hank_hours + 9 * paul_hours + 10 * mary_hours >= 44)

m.addConstr(22 * hank_hours + 21 * paul_hours >= 49)
m.addConstr(21 * paul_hours + 3 * dale_hours >= 47)
m.addConstr(22 * hank_hours + 21 * paul_hours + 3 * dale_hours >= 46)


m.addConstr(25 * paul_hours + 8 * dale_hours <= 183)
m.addConstr(18 * hank_hours + 8 * dale_hours <= 227)
m.addConstr(18 * hank_hours + 2 * mary_hours <= 304)
m.addConstr(8 * dale_hours + 2 * mary_hours <= 357)
m.addConstr(25 * paul_hours + 2 * mary_hours <= 410)
m.addConstr(18 * hank_hours + 25 * paul_hours + 8 * dale_hours + 2 * mary_hours <= 410)

m.addConstr(17 * hank_hours + 26 * paul_hours <= 200)
m.addConstr(26 * paul_hours + 7 * mary_hours <= 267)
m.addConstr(26 * paul_hours + 4 * dale_hours <= 201)
m.addConstr(26 * paul_hours + 4 * dale_hours + 7 * mary_hours <= 129)
m.addConstr(17 * hank_hours + 26 * paul_hours + 4 * dale_hours + 7 * mary_hours <= 129)

m.addConstr(10 * hank_hours + 9 * paul_hours <= 148)
m.addConstr(10 * hank_hours + 10 * mary_hours <= 236)
m.addConstr(21 * dale_hours + 10 * mary_hours <= 150)
m.addConstr(10 * hank_hours + 21 * dale_hours <= 115)
m.addConstr(9 * paul_hours + 21 * dale_hours <= 120)
m.addConstr(10 * hank_hours + 9 * paul_hours + 21 * dale_hours + 10 * mary_hours <= 120)

m.addConstr(21 * paul_hours + 3 * dale_hours <= 118)
m.addConstr(21 * paul_hours + 2 * mary_hours <= 175)
m.addConstr(3 * dale_hours + 2 * mary_hours <= 104)
m.addConstr(22 * hank_hours + 2 * mary_hours <= 216)
m.addConstr(22 * hank_hours + 21 * paul_hours + 3 * dale_hours + 2 * mary_hours <= 216)

m.addConstr(9 * hank_hours + 18 * dale_hours <= 252)
m.addConstr(12 * paul_hours + 24 * mary_hours <= 178)
m.addConstr(12 * paul_hours + 18 * dale_hours <= 140)
m.addConstr(18 * dale_hours + 24 * mary_hours <= 184)
m.addConstr(9 * hank_hours + 12 * paul_hours + 24 * mary_hours <= 267)
m.addConstr(12 * paul_hours + 18 * dale_hours + 24 * mary_hours <= 184)
m.addConstr(9 * hank_hours + 18 * dale_hours + 24 * mary_hours <= 261)
m.addConstr(9 * hank_hours + 12 * paul_hours + 18 * dale_hours + 24 * mary_hours <= 261)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Hank Hours: %g' % hank_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
