
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(lb=0, name="H")
P = m.addVar(lb=0, name="P")
D = m.addVar(lb=0, name="D")
M = m.addVar(lb=0, name="M")

# Define the objective function
m.setObjective(7*H + 4*P + 8*D + 5*M, gp.GRB.MAXIMIZE)

# Add constraints
# Computer competence rating constraints
m.addConstr(18*H + 8*D + 2*M >= 105)
m.addConstr(18*H + 25*P + 2*M >= 105)
m.addConstr(18*H + 25*P + 8*D >= 105)
m.addConstr(18*H + 8*D + 2*M >= 54)
m.addConstr(18*H + 25*P + 2*M >= 54)
m.addConstr(18*H + 25*P + 8*D >= 54)
m.addConstr(18*H + 8*D + 2*M >= 95)
m.addConstr(18*H + 25*P + 2*M >= 95)
m.addConstr(18*H + 25*P + 8*D >= 95)

# Dollar cost per hour constraints
m.addConstr(17*H + 4*D >= 72)
m.addConstr(17*H + 7*M >= 82)
m.addConstr(26*P + 4*D >= 92)
m.addConstr(17*H + 26*P >= 48)
m.addConstr(17*H + 26*P + 7*M >= 82)

# Likelihood to quit index constraints
m.addConstr(10*H + 9*P + 21*D >= 46)
m.addConstr(10*H + 21*D + 10*M >= 46)
m.addConstr(10*H + 9*P + 10*M >= 46)
m.addConstr(10*H + 9*P + 21*D >= 74)
m.addConstr(10*H + 21*D + 10*M >= 74)
m.addConstr(10*H + 9*P + 10*M >= 74)
m.addConstr(10*H + 9*P + 21*D >= 44)
m.addConstr(10*H + 21*D + 10*M >= 44)
m.addConstr(10*H + 9*P + 10*M >= 44)

# Organization score constraints
m.addConstr(22*H + 21*P >= 49)
m.addConstr(21*P + 3*D >= 47)
m.addConstr(22*H + 21*P + 3*D >= 46)

# Computer competence rating upper bound constraints
m.addConstr(25*P + 8*D <= 183)
m.addConstr(18*H + 8*D <= 227)
m.addConstr(18*H + 2*M <= 304)
m.addConstr(8*D + 2*M <= 357)
m.addConstr(25*P + 2*M <= 410)
m.addConstr(18*H + 25*P + 8*D + 2*M <= 410)

# Dollar cost per hour upper bound constraints
m.addConstr(17*H + 26*P <= 200)
m.addConstr(26*P + 7*M <= 267)
m.addConstr(26*P + 4*D <= 201)
m.addConstr(26*P + 4*D + 7*M <= 129)
m.addConstr(17*H + 26*P + 4*D + 7*M <= 129)

# Likelihood to quit index upper bound constraints
m.addConstr(10*H + 9*P <= 148)
m.addConstr(10*H + 10*M <= 236)
m.addConstr(21*D + 10*M <= 150)
m.addConstr(10*H + 21*D <= 115)
m.addConstr(9*P + 21*D <= 120)
m.addConstr(10*H + 9*P + 21*D + 10*M <= 120)

# Organization score upper bound constraints
m.addConstr(21*P + 3*D <= 118)
m.addConstr(21*P + 2*M <= 175)
m.addConstr(3*D + 2*M <= 104)
m.addConstr(22*H + 2*M <= 216)
m.addConstr(22*H + 21*P + 3*D + 2*M <= 216)

# Work quality rating constraints
m.addConstr(9*H + 18*D <= 252)
m.addConstr(12*P + 24*M <= 178)
m.addConstr(12*P + 18*D <= 140)
m.addConstr(18*D + 24*M <= 184)
m.addConstr(9*H + 12*P + 24*M <= 267)
m.addConstr(12*P + 18*D + 24*M <= 184)
m.addConstr(9*H + 18*D + 24*M <= 261)
m.addConstr(9*H + 12*P + 18*D + 24*M <= 261)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"H: {H.varValue}")
    print(f"P: {P.varValue}")
    print(f"D: {D.varValue}")
    print(f"M: {M.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
