
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
knishes = m.addVar(vtype=gp.GRB.INTEGER, name="knishes")
protein_bars = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")

# Set objective function
m.setObjective(1.71 * knishes**2 + 1.41 * knishes * protein_bars + 6.44 * protein_bars**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * knishes**2 + 5 * protein_bars**2 >= 46, "iron_constraint1")
m.addConstr(6 * knishes - 3 * protein_bars >= 0, "constraint2")
m.addConstr(5 * knishes**2 + 5 * protein_bars**2 <= 52, "iron_constraint3")
m.addConstr(5 * knishes + 5 * protein_bars <= 52, "iron_constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of knishes: {knishes.x}")
    print(f"Number of protein bars: {protein_bars.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

