
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
knishes = m.addVar(vtype=GRB.INTEGER, name="knishes")
protein_bars = m.addVar(vtype=GRB.CONTINUOUS, name="protein_bars")

# Objective function: Maximize
m.setObjective(1.71 * knishes**2 + 1.41 * knishes * protein_bars + 6.44 * protein_bars**2, GRB.MAXIMIZE)

# Constraints
# At least 46 milligrams of iron from squares
m.addConstr(knishes**2 * 5 + protein_bars**2 * 5 >= 46, name="iron_from_squares_min")

# Total iron from squares does not exceed 52 milligrams
m.addConstr(knishes**2 * 5 + protein_bars**2 * 5 <= 52, name="iron_from_squares_max")

# 6 times knishes minus 3 times protein bars is at least 0
m.addConstr(6 * knishes - 3 * protein_bars >= 0, name="knishes_protein_bars_ratio")

# Total iron from knishes and protein bars does not exceed 52 milligrams
m.addConstr(knishes * 5 + protein_bars * 5 <= 52, name="total_iron_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Knishes: {knishes.x}")
    print(f"Protein Bars: {protein_bars.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
