
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x0 = m.addVar(lb=0, name="tomatoes")  # Number of tomatoes
x1 = m.addVar(lb=0, name="corn_cobs")  # Number of corn cobs

# Set the objective function
m.setObjective(3.97*x0 + 3.18*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.53*x0 + 2.22*x1 >= 7, name="healthiness_rating_lower")
m.addConstr(4.2*x0 + 2.22*x1 >= 19, name="fat_grams_lower")
m.addConstr(0.28*x0 + 4.12*x1 >= 5, name="umami_index_lower")
m.addConstr(-7*x0 + x1 >= 0, name="mixed_constraint")
m.addConstr(0.53*x0 + 2.22*x1 <= 14, name="healthiness_rating_upper")
m.addConstr(4.2*x0 + 2.22*x1 <= 47, name="fat_grams_upper")
m.addConstr(0.28*x0 + 4.12*x1 <= 7, name="umami_index_upper")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Tomatoes: {x0.x}, Corn Cobs: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
