
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
tomatoes = m.addVar(name="tomatoes", lb=-gp.GRB.INFINITY)
corn_cobs = m.addVar(name="corn_cobs", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3.97 * tomatoes + 3.18 * corn_cobs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.53 * tomatoes + 2.22 * corn_cobs >= 7, name="healthiness_rating")
m.addConstr(4.2 * tomatoes + 2.22 * corn_cobs >= 19, name="grams_of_fat")
m.addConstr(0.28 * tomatoes + 4.12 * corn_cobs >= 5, name="umami_index")
m.addConstr(-7 * tomatoes + corn_cobs >= 0, name="tomatoes_corn_cobs_constraint")
m.addConstr(0.53 * tomatoes + 2.22 * corn_cobs <= 14, name="healthiness_rating_upper_bound")
m.addConstr(4.2 * tomatoes + 2.22 * corn_cobs <= 47, name="grams_of_fat_upper_bound")
m.addConstr(0.28 * tomatoes + 4.12 * corn_cobs <= 7, name="umami_index_upper_bound")

# Optimize the model
m.optimize()

# Print the status of the model
if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal Solution:")
    print(f"Tomatoes: {tomatoes.varValue}")
    print(f"Corn Cobs: {corn_cobs.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
