
import gurobipy as gp

# Create a new model
m = gp.Model("WorkHoursOptimization")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Jean")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Ringo")

# Set objective function
m.setObjective(2 * jean + 2 * hank + 9 * bobby + 7 * ringo, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(32 * hank + 17 * bobby >= 205, "c1")
m.addConstr(23 * jean + 32 * hank + 17 * bobby + 12 * ringo >= 205, "c2")
m.addConstr(10 * bobby + 10 * ringo >= 64, "c3")
m.addConstr(15 * hank + 10 * ringo >= 70, "c4")
m.addConstr(27 * jean + 10 * ringo >= 67, "c5")
m.addConstr(27 * jean + 15 * hank + 10 * bobby + 10 * ringo >= 67, "c6")
m.addConstr(-7 * jean + 4 * bobby >= 0, "c7")
m.addConstr(8 * bobby - 6 * ringo >= 0, "c8")
m.addConstr(-10 * hank + 2 * bobby + 4 * ringo >= 0, "c9")
m.addConstr(23 * jean + 32 * hank + 12 * ringo <= 632, "c10")
m.addConstr(15 * hank + 10 * ringo <= 331, "c11")
m.addConstr(10 * bobby + 10 * ringo <= 170, "c12")
m.addConstr(27 * jean + 10 * ringo <= 228, "c13")
m.addConstr(27 * jean + 15 * hank <= 130, "c14")
m.addConstr(27 * jean + 10 * bobby <= 118, "c15")
m.addConstr(27 * jean + 15 * hank + 10 * bobby <= 295, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

