
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Jean')
x1 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Hank')
x2 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Bobby')
x3 = m.addVar(vtype=GRB.CONTINUOUS, name='hours_worked_by_Ringo')

# Objective function
m.setObjective(2*x0 + 2*x1 + 9*x2 + 7*x3, GRB.MINIMIZE)

# Constraints
# Minimum productivity constraints
m.addConstr(32*x1 + 17*x2 >= 205, name='min_productivity_hb')
m.addConstr(23*x0 + 32*x1 + 17*x2 + 12*x3 >= 205, name='min_total_productivity')

# Minimum computer competence constraints
m.addConstr(10*x2 + 10*x3 >= 64, name='min_computer_bobby_ringo')
m.addConstr(15*x1 + 10*x3 >= 70, name='min_computer_hank_ringo')
m.addConstr(27*x0 + 10*x3 >= 67, name='min_computer_jean_ringo')
m.addConstr(27*x0 + 15*x1 + 10*x2 + 10*x3 >= 67, name='min_total_computer')

# Additional linear constraints
m.addConstr(-7*x0 + 4*x2 >= 0, name='constraint_jean_bobby')
m.addConstr(8*x2 - 6*x3 >= 0, name='constraint_bobby_ringo')
m.addConstr(-10*x1 + 2*x2 + 4*x3 >= 0, name='constraint_hank_bobby_ringo')

# Maximum productivity and computer competence constraints
m.addConstr(23*x0 + 32*x1 + 12*x3 <= 632, name='max_productivity_jhr')
m.addConstr(15*x1 + 10*x3 <= 331, name='max_computer_hank_ringo')
m.addConstr(10*x2 + 10*x3 <= 170, name='max_computer_bobby_ringo')
m.addConstr(27*x0 + 10*x3 <= 228, name='max_computer_jean_ringo')
m.addConstr(27*x0 + 15*x1 <= 130, name='max_computer_jean_hank')
m.addConstr(27*x0 + 10*x2 <= 118, name='max_computer_jean_bobby')
m.addConstr(27*x0 + 15*x1 + 10*x2 <= 295, name='max_total_computer_jhb')

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f'{v.varName}: {v.x}')

print(f'Objective: {m.objVal}')
