
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Jean", lb=0)
    x1 = model.addVar(name="hours_worked_by_Hank", lb=0)
    x2 = model.addVar(name="hours_worked_by_Bobby", lb=0)
    x3 = model.addVar(name="hours_worked_by_Ringo", lb=0)

    # Define the objective function
    model.setObjective(2*x0 + 2*x1 + 9*x2 + 7*x3, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(32*x1 + 17*x2 >= 205)
    model.addConstr(23*x0 + 32*x1 + 17*x2 + 12*x3 >= 205)
    model.addConstr(10*x2 + 10*x3 >= 64)
    model.addConstr(15*x1 + 10*x3 >= 70)
    model.addConstr(27*x0 + 10*x3 >= 67)
    model.addConstr(27*x0 + 15*x1 + 10*x2 + 10*x3 >= 67)
    model.addConstr(-7*x0 + 4*x2 >= 0)
    model.addConstr(8*x2 - 6*x3 >= 0)
    model.addConstr(-10*x1 + 2*x2 + 4*x3 >= 0)
    model.addConstr(23*x0 + 32*x1 + 12*x3 <= 632)
    model.addConstr(15*x1 + 10*x3 <= 331)
    model.addConstr(10*x2 + 10*x3 <= 170)
    model.addConstr(27*x0 + 10*x3 <= 228)
    model.addConstr(27*x0 + 15*x1 <= 130)
    model.addConstr(27*x0 + 10*x2 <= 118)
    model.addConstr(27*x0 + 15*x1 + 10*x2 <= 295)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Jean: ", x0.varValue)
        print("Hours worked by Hank: ", x1.varValue)
        print("Hours worked by Bobby: ", x2.varValue)
        print("Hours worked by Ringo: ", x3.varValue)
        print("Objective value: ", model.objVal)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
