
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
black_beans = m.addVar(lb=0, name="black_beans")
bananas = m.addVar(lb=0, name="bananas")
corn_cobs = m.addVar(lb=0, name="corn_cobs")
hamburgers = m.addVar(lb=0, name="hamburgers")

# Set objective function
m.setObjective(7 * black_beans + 8 * bananas + 4 * corn_cobs + 7 * hamburgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(10.38 * black_beans + 5.97 * bananas + 9.6 * corn_cobs + 1.28 * hamburgers <= 136, "r0")
m.addConstr(8.04 * black_beans + 3.8 * bananas + 7.77 * corn_cobs + 9.58 * hamburgers <= 177, "r1")
m.addConstr(2.96 * black_beans + 7.25 * bananas + 1.68 * corn_cobs + 9.9 * hamburgers <= 169, "r2")
m.addConstr(8.47 * black_beans + 4.45 * bananas + 5.45 * corn_cobs + 0.76 * hamburgers <= 160, "r3")
m.addConstr(8.75 * black_beans + 5.16 * bananas + 2.4 * corn_cobs + 8.76 * hamburgers <= 244, "r4")

m.addConstr(5.97 * bananas + 9.6 * corn_cobs >= 24, "c1")
m.addConstr(10.38 * black_beans + 9.6 * corn_cobs >= 16, "c2")
m.addConstr(10.38 * black_beans + 5.97 * bananas + 1.28 * hamburgers >= 25, "c3")
m.addConstr(10.38 * black_beans + 5.97 * bananas + 9.6 * corn_cobs + 1.28 * hamburgers >= 25, "c4")

m.addConstr(8.04 * black_beans + 3.8 * bananas >= 23, "c5")
m.addConstr(8.04 * black_beans + 9.58 * hamburgers >= 39, "c6")
m.addConstr(8.04 * black_beans + 7.77 * corn_cobs >= 23, "c7")
m.addConstr(8.04 * black_beans + 3.8 * bananas + 9.58 * hamburgers >= 28, "c8")
m.addConstr(8.04 * black_beans + 7.77 * corn_cobs + 9.58 * hamburgers >= 28, "c9")
m.addConstr(8.04 * black_beans + 3.8 * bananas + 9.58 * hamburgers >= 32, "c10")
m.addConstr(8.04 * black_beans + 7.77 * corn_cobs + 9.58 * hamburgers >= 32, "c11")
m.addConstr(8.04 * black_beans + 3.8 * bananas + 7.77 * corn_cobs + 9.58 * hamburgers >= 32, "c12")

m.addConstr(7.25 * bananas + 1.68 * corn_cobs >= 29, "c13")
m.addConstr(2.96 * black_beans + 9.9 * hamburgers >= 30, "c14")
m.addConstr(2.96 * black_beans + 1.68 * corn_cobs >= 19, "c15")
m.addConstr(2.96 * black_beans + 7.25 * bananas + 1.68 * corn_cobs >= 30, "c16")
m.addConstr(2.96 * black_beans + 7.25 * bananas + 1.68 * corn_cobs + 9.9 * hamburgers >= 30, "c17")

m.addConstr(4.45 * bananas + 5.45 * corn_cobs >= 23, "c18")
m.addConstr(8.47 * black_beans + 5.45 * corn_cobs >= 20, "c19")
m.addConstr(8.47 * black_beans + 0.76 * hamburgers >= 24, "c20")
m.addConstr(5.45 * corn_cobs + 0.76 * hamburgers >= 36, "c21")
m.addConstr(8.47 * black_beans + 4.45 * bananas + 0.76 * hamburgers >= 28, "c22")
m.addConstr(8.47 * black_beans + 4.45 * bananas + 5.45 * corn_cobs + 0.76 * hamburgers >= 28, "c23")


m.addConstr(8.75 * black_beans + 5.16 * bananas >= 29, "c24")
m.addConstr(8.75 * black_beans + 5.16 * bananas + 2.4 * corn_cobs + 8.76 * hamburgers >= 29, "c25")

m.addConstr(bananas - 2 * hamburgers >= 0, "c26")
m.addConstr(3 * black_beans - 10 * corn_cobs >= 0, "c27")
m.addConstr(3 * corn_cobs - 10 * hamburgers >= 0, "c28")

m.addConstr(3.8 * bananas + 7.77 * corn_cobs <= 55, "c29")
m.addConstr(8.04 * black_beans + 9.58 * hamburgers <= 84, "c30")
m.addConstr(7.77 * corn_cobs + 9.58 * hamburgers <= 123, "c31")
m.addConstr(3.8 * bananas + 9.58 * hamburgers <= 154, "c32")
m.addConstr(3.8 * bananas + 7.77 * corn_cobs + 9.58 * hamburgers <= 172, "c33")
m.addConstr(8.04 * black_beans + 3.8 * bananas + 9.58 * hamburgers <= 69, "c34")
m.addConstr(8.04 * black_beans + 7.77 * corn_cobs + 9.58 * hamburgers <= 104, "c35")

m.addConstr(2.96 * black_beans + 9.9 * hamburgers <= 48, "c36")
m.addConstr(2.96 * black_beans + 7.25 * bananas <= 163, "c37")
m.addConstr(7.25 * bananas + 1.68 * corn_cobs <= 88, "c38")
m.addConstr(2.96 * black_beans + 1.68 * corn_cobs <= 80, "c39")
m.addConstr(1.68 * corn_cobs + 9.9 * hamburgers <= 137, "c40")
m.addConstr(7.25 * bananas + 9.9 * hamburgers <= 62, "c41")

m.addConstr(8.47 * black_beans + 5.45 * corn_cobs + 0.76 * hamburgers <= 151, "c42")

m.addConstr(8.75 * black_beans + 8.76 * hamburgers <= 213, "c43")
m.addConstr(5.16 * bananas + 8.76 * hamburgers <= 101, "c44")
m.addConstr(5.16 * bananas + 2.4 * corn_cobs <= 180, "c45")
m.addConstr(8.75 * black_beans + 5.16 * bananas + 8.76 * hamburgers <= 75, "c46")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

