
from gurobipy import Model, GRB

# Create a new model
model = Model("calcium_optimization")

# Create variables
milkshakes = model.addVar(vtype=GRB.INTEGER, name="milkshakes")
sashimi = model.addVar(vtype=GRB.INTEGER, name="sashimi")

# Set objective function
model.setObjective(7 * milkshakes + 1 * sashimi, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * milkshakes + 12 * sashimi >= 31, "calcium_min")
model.addConstr(-6 * milkshakes + 7 * sashimi >= 0, "milkshake_sashimi_ratio")
model.addConstr(2 * milkshakes + 12 * sashimi <= 52, "calcium_max1") # Combined the duplicate constraint
model.addConstr(2 * milkshakes + 12 * sashimi <= 52, "calcium_max2") # Combined the duplicate constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Number of milkshakes: {milkshakes.x}")
    print(f"Number of sashimi: {sashimi.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

