
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    milkshakes = model.addVar(vtype=gurobi.GRB.INTEGER, name="milkshakes")
    sashimi = model.addVar(vtype=gurobi.GRB.INTEGER, name="sashimi")

    # Objective function
    model.setObjective(7 * (milkshakes + 1) * sashimi, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * milkshakes + 12 * sashimi >= 31, name="calcium_min")
    model.addConstr(2 * milkshakes + 12 * sashimi <= 52, name="calcium_max")
    model.addConstr(-6 * milkshakes + 7 * sashimi >= 0, name="linear_constraint")

    # Calcium bounds from the problem description
    # Not necessary to explicitly define r0 as it's already considered in constraints

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Sashimi: {sashimi.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
