
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bobby_hours = m.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = m.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")
george_hours = m.addVar(vtype=gp.GRB.INTEGER, name="george_hours")

# Set objective function
m.setObjective(5 * bobby_hours + 8 * peggy_hours + 8 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * peggy_hours + 26 * george_hours >= 99, "dollar_cost_peggy_george")
m.addConstr(13 * bobby_hours + 10 * peggy_hours >= 97, "dollar_cost_bobby_peggy")
m.addConstr(13 * bobby_hours + 10 * peggy_hours + 26 * george_hours >= 64, "dollar_cost_all_min")
m.addConstr(9 * peggy_hours + 6 * george_hours >= 68, "paperwork_peggy_george")
m.addConstr(8 * bobby_hours + 9 * peggy_hours >= 86, "paperwork_bobby_peggy")
m.addConstr(8 * bobby_hours + 6 * george_hours >= 41, "paperwork_bobby_george")
m.addConstr(8 * bobby_hours + 9 * peggy_hours + 6 * george_hours >= 41, "paperwork_all")
m.addConstr(-6 * bobby_hours + 4 * peggy_hours >= 0, "bobby_peggy_relation")
m.addConstr(-7 * peggy_hours + 6 * george_hours >= 0, "peggy_george_relation")
m.addConstr(8 * bobby_hours + 6 * george_hours <= 272, "paperwork_bobby_george_max")
m.addConstr(9 * peggy_hours + 6 * george_hours <= 191, "paperwork_peggy_george_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('George Hours: %g' % george_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

