
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Bobby", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="hours_worked_by_Peggy", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x0 + 8*x1 + 8*x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(10*x1 + 26*x2 >= 99, name="dollar_cost_Peggy_George")
m.addConstr(13*x0 + 10*x1 >= 97, name="dollar_cost_Bobby_Peggy")
m.addConstr(13*x0 + 10*x1 + 26*x2 >= 64, name="dollar_cost_total")
m.addConstr(9*x1 + 6*x2 >= 68, name="paperwork_Peggy_George")
m.addConstr(8*x0 + 9*x1 >= 86, name="paperwork_Bobby_Peggy")
m.addConstr(8*x0 + 6*x2 >= 41, name="paperwork_Bobby_George")
m.addConstr(-6*x0 + 4*x1 >= 0, name="Bobby_Peggy_tradeoff")
m.addConstr(-7*x1 + 6*x2 >= 0, name="Peggy_George_tradeoff")
m.addConstr(8*x0 + 6*x2 <= 272, name="paperwork_Bobby_George_limit")
m.addConstr(9*x1 + 6*x2 <= 191, name="paperwork_Peggy_George_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x0.varValue}")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
