
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_D", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams_of_vitamin_B9")
    x2 = model.addVar(name="milligrams_of_zinc")

    # Define the objective function
    model.setObjective(3.53 * x0 + 5.16 * x1 + 2.52 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * x0 <= 198)
    model.addConstr(x0 <= 135)
    model.addConstr(2 * x0 <= 174)
    model.addConstr(6 * x1 <= 198)
    model.addConstr(4 * x1 <= 135)
    model.addConstr(7 * x1 <= 174)
    model.addConstr(11 * x2 <= 198)
    model.addConstr(2 * x2 <= 135)
    model.addConstr(11 * x2 <= 174)
    model.addConstr(6 * x1 + 11 * x2 >= 36)
    model.addConstr(5 * x0 + 6 * x1 + 11 * x2 >= 36)
    model.addConstr(x0 + 4 * x1 >= 44)
    model.addConstr(x0 + 4 * x1 + 2 * x2 >= 44)
    model.addConstr(2 * x0 + 7 * x1 >= 20)
    model.addConstr(2 * x0 + 11 * x2 >= 33)
    model.addConstr(2 * x0 + 7 * x1 + 11 * x2 >= 33)
    model.addConstr(7 * x0 - 10 * x2 >= 0)
    model.addConstr(9 * x1 - 3 * x2 >= 0)
    model.addConstr(-5 * x0 + 8 * x1 >= 0)
    model.addConstr(5 * x0 + 6 * x1 <= 150)
    model.addConstr(2 * x0 + 11 * x2 <= 164)
    model.addConstr(7 * x1 + 11 * x2 <= 173)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x0.varValue}")
        print(f"Milligrams of vitamin B9: {x1.varValue}")
        print(f"Milligrams of zinc: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
