
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="grams_of_protein", lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_B2", lb=0)
    x2 = model.addVar(name="grams_of_carbohydrates", lb=0)

    # Objective function
    model.setObjective(1 * x0 + 6 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.48 * x0 <= 202, name="muscle_growth_index_protein")
    model.addConstr(3.0 * x0 <= 144, name="kidney_support_index_protein")
    model.addConstr(0.28 * x0 <= 201, name="energy_stability_index_protein")

    model.addConstr(3.43 * x1 <= 202, name="muscle_growth_index_vitamin_B2")
    model.addConstr(3.44 * x1 <= 144, name="kidney_support_index_vitamin_B2")
    model.addConstr(2.49 * x1 <= 201, name="energy_stability_index_vitamin_B2")

    model.addConstr(0.04 * x2 <= 202, name="muscle_growth_index_carbohydrates")
    model.addConstr(3.52 * x2 <= 144, name="kidney_support_index_carbohydrates")
    model.addConstr(1.22 * x2 <= 201, name="energy_stability_index_carbohydrates")

    model.addConstr(3.48 * x0 + 0.04 * x2 >= 28, name="muscle_growth_index_total_1")
    model.addConstr(3.48 * x0 + 3.43 * x1 >= 34, name="muscle_growth_index_total_2")
    model.addConstr(3.0 * x0 + 3.44 * x1 >= 25, name="kidney_support_index_total_1")
    model.addConstr(0.28 * x0 + 2.49 * x1 >= 54, name="energy_stability_index_total_1")

    model.addConstr(6 * x1 - 5 * x2 >= 0, name="vitamin_B2_carbohydrates_constraint")

    model.addConstr(3.43 * x1 + 0.04 * x2 <= 129, name="muscle_growth_index_total_3")
    model.addConstr(3.48 * x0 + 0.04 * x2 <= 176, name="muscle_growth_index_total_4")
    model.addConstr(3.48 * x0 + 3.43 * x1 + 0.04 * x2 <= 176, name="muscle_growth_index_total_5")

    model.addConstr(3.44 * x1 + 3.52 * x2 <= 128, name="kidney_support_index_total_2")
    model.addConstr(3.0 * x0 + 3.52 * x2 <= 61, name="kidney_support_index_total_3")
    model.addConstr(3.0 * x0 + 3.44 * x1 + 3.52 * x2 <= 61, name="kidney_support_index_total_4")

    model.addConstr(2.49 * x1 + 1.22 * x2 <= 157, name="energy_stability_index_total_2")
    model.addConstr(0.28 * x0 + 2.49 * x1 <= 79, name="energy_stability_index_total_3")
    model.addConstr(0.28 * x0 + 2.49 * x1 + 1.22 * x2 <= 79, name="energy_stability_index_total_4")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Grams of protein: ", x0.varValue)
        print("Milligrams of vitamin B2: ", x1.varValue)
        print("Grams of carbohydrates: ", x2.varValue)
    else:
        print("The model is infeasible")

optimize()
