
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hours Optimization")

# Create variables
dale_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Dale_Hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="Mary_Hours")
jean_hours = model.addVar(vtype=GRB.INTEGER, name="Jean_Hours")
peggy_hours = model.addVar(vtype=GRB.INTEGER, name="Peggy_Hours")

# Set objective function
model.setObjective(3.77 * dale_hours + 4.37 * mary_hours + 2.05 * jean_hours + 7.17 * peggy_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * dale_hours + 23 * mary_hours + 19 * peggy_hours >= 96, "Dollar Cost Constraint 1")
model.addConstr(15 * dale_hours + 6 * jean_hours + 19 * peggy_hours >= 96, "Dollar Cost Constraint 2")
model.addConstr(23 * mary_hours + 6 * jean_hours + 19 * peggy_hours >= 96, "Dollar Cost Constraint 3")
model.addConstr(15 * dale_hours + 23 * mary_hours + 19 * peggy_hours >= 93, "Dollar Cost Constraint 4")
model.addConstr(15 * dale_hours + 6 * jean_hours + 19 * peggy_hours >= 93, "Dollar Cost Constraint 5")
model.addConstr(23 * mary_hours + 6 * jean_hours + 19 * peggy_hours >= 93, "Dollar Cost Constraint 6")
model.addConstr(15 * dale_hours + 23 * mary_hours + 19 * peggy_hours >= 105, "Dollar Cost Constraint 7")
model.addConstr(15 * dale_hours + 6 * jean_hours + 19 * peggy_hours >= 105, "Dollar Cost Constraint 8")
model.addConstr(23 * mary_hours + 6 * jean_hours + 19 * peggy_hours >= 105, "Dollar Cost Constraint 9")

model.addConstr(13 * dale_hours + 2 * peggy_hours >= 92, "Likelihood to Quit Constraint 1")
model.addConstr(13 * dale_hours + 11 * mary_hours >= 141, "Likelihood to Quit Constraint 2")

model.addConstr(15 * dale_hours + 23 * mary_hours <= 349, "Dollar Cost Constraint 10")
model.addConstr(6 * jean_hours + 19 * peggy_hours <= 464, "Dollar Cost Constraint 11")
model.addConstr(23 * mary_hours + 19 * peggy_hours <= 446, "Dollar Cost Constraint 12")
model.addConstr(15 * dale_hours + 23 * mary_hours + 19 * peggy_hours <= 393, "Dollar Cost Constraint 13")
model.addConstr(15 * dale_hours + 23 * mary_hours + 6 * jean_hours <= 484, "Dollar Cost Constraint 14")
model.addConstr(23 * mary_hours + 6 * jean_hours + 19 * peggy_hours <= 176, "Dollar Cost Constraint 15")
model.addConstr(15 * dale_hours + 6 * jean_hours + 19 * peggy_hours <= 215, "Dollar Cost Constraint 16")
model.addConstr(15 * dale_hours + 23 * mary_hours + 6 * jean_hours + 19 * peggy_hours <= 215, "Dollar Cost Constraint 17")

model.addConstr(13 * dale_hours + 20 * jean_hours <= 533, "Likelihood to Quit Constraint 3")
model.addConstr(20 * jean_hours + 2 * peggy_hours <= 396, "Likelihood to Quit Constraint 4")
model.addConstr(11 * mary_hours + 2 * peggy_hours <= 320, "Likelihood to Quit Constraint 5")
model.addConstr(13 * dale_hours + 11 * mary_hours + 2 * peggy_hours <= 522, "Likelihood to Quit Constraint 6")
model.addConstr(13 * dale_hours + 11 * mary_hours + 20 * jean_hours + 2 * peggy_hours <= 522, "Likelihood to Quit Constraint 7")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dale's hours: {dale_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}.")

