
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
D = m.addVar(lb=0, name="D")  # Continuous
M = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="M")  # Integer
J = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="J")  # Integer
P = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="P")  # Integer

# Objective function
m.setObjective(3.77*D + 4.37*M + 2.05*J + 7.17*P, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(15*D + 23*M + 19*P >= 96)
m.addConstr(15*D + 6*J + 19*P >= 96)
m.addConstr(23*M + 6*J + 19*P >= 96)
m.addConstr(15*D + 23*M + 19*P >= 93)
m.addConstr(15*D + 6*J + 19*P >= 93)
m.addConstr(23*M + 6*J + 19*P >= 93)
m.addConstr(15*D + 23*M + 19*P >= 105)
m.addConstr(15*D + 6*J + 19*P >= 105)
m.addConstr(23*M + 6*J + 19*P >= 105)
m.addConstr(13*D + 2*P >= 92)
m.addConstr(13*D + 11*M >= 141)
m.addConstr(15*D + 23*M <= 349)
m.addConstr(6*J + 19*P <= 464)
m.addConstr(23*M + 19*P <= 446)
m.addConstr(15*D + 23*M + 19*P <= 393)
m.addConstr(15*D + 23*M + 6*J <= 484)
m.addConstr(23*M + 6*J + 19*P <= 176)
m.addConstr(15*D + 6*J + 19*P <= 215)
m.addConstr(15*D + 23*M + 6*J + 19*P <= 215)
m.addConstr(13*D + 20*J <= 533)
m.addConstr(20*J + 2*P <= 396)
m.addConstr(11*M + 2*P <= 320)
m.addConstr(13*D + 11*M + 2*P <= 522)
m.addConstr(13*D + 11*M + 20*J + 2*P <= 522)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("D: ", D.varValue)
    print("M: ", M.varValue)
    print("J: ", J.varValue)
    print("P: ", P.varValue)
else:
    print("The problem is infeasible")
