
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")

# Set objective function
m.setObjective(3*x0**2 + x1**2 + 4*x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.36*x0 + 2.16*x1 >= 20, "min_mobility_rating")
m.addConstr(4.77*x0 + 3.38*x1 >= 12, "min_deployment_weight")
m.addConstr(3.67*x0 + 0.07*x1 >= 18, "min_logistics_footprint")
m.addConstr(0.4*x0**2 + 5.92*x1**2 >= 20, "min_logistical_capacity")
m.addConstr(5.77*x0**2 + 7.12*x1**2 >= 15, "min_fun_factor")
m.addConstr(2*x0 - 6*x1 >= 0, "custom_constraint_1")

m.addConstr(1.36*x0 + 2.16*x1 <= 41, "max_mobility_rating_1") # Redundant constraint
m.addConstr(1.36*x0 + 2.16*x1 <= 41, "max_mobility_rating_2") # Redundant constraint
m.addConstr(4.77*x0 + 3.38*x1 <= 27, "max_deployment_weight_1") # Redundant constraint
m.addConstr(4.77*x0 + 3.38*x1 <= 27, "max_deployment_weight_2") # Redundant constraint
m.addConstr(3.67*x0 + 0.07*x1 <= 23, "max_logistics_footprint_1") # Redundant constraint
m.addConstr(3.67*x0 + 0.07*x1 <= 23, "max_logistics_footprint_2") # Redundant constraint
m.addConstr(0.4*x0 + 5.92*x1 <= 30, "max_logistical_capacity_1") # Redundant constraint
m.addConstr(0.4*x0 + 5.92*x1 <= 30, "max_logistical_capacity_2") # Redundant constraint
m.addConstr(5.77*x0 + 7.12*x1 <= 19, "max_fun_factor_1") # Redundant constraint
m.addConstr(5.77*x0 + 7.12*x1 <= 19, "max_fun_factor_2") # Redundant constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('reconnaissance_troops:', x0.x)
    print('engineer_platoons:', x1.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

