
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="engineer_platoons")

# Objective function: Maximize 3*x0^2 + x1^2 + 4*x1
m.setObjective(3 * x0**2 + x1**2 + 4 * x1, GRB.MAXIMIZE)

# Constraints
# Mobility rating constraints
m.addConstr(x0 * 1.36 + x1 * 2.16 >= 20, name="min_mobility")
m.addConstr(x0 * 1.36 + x1 * 2.16 <= 41, name="max_mobility")

# Deployment weight constraints
m.addConstr(x0 * 4.77 + x1 * 3.38 >= 12, name="min_deployment_weight")
m.addConstr(x0 * 4.77 + x1 * 3.38 <= 27, name="max_deployment_weight")

# Logistics footprint constraints
m.addConstr(x0 * 3.67 + x1 * 0.07 >= 18, name="min_logistics_footprint")
m.addConstr(x0 * 3.67 + x1 * 0.07 <= 23, name="max_logistics_footprint")

# Logistical capacity constraints
m.addConstr((x0 * 0.4)**2 + (x1 * 5.92)**2 >= 20, name="min_logistical_capacity")
m.addConstr(x0 * 0.4 + x1 * 5.92 <= 30, name="max_logistical_capacity")

# Fun factor constraints
m.addConstr((x0 * 5.77)**2 + (x1 * 7.12)**2 >= 15, name="min_fun_factor")
m.addConstr(x0 * 5.77 + x1 * 7.12 <= 19, name="max_fun_factor")

# Additional linear constraint
m.addConstr(2*x0 - 6*x1 >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance troops: {x0.X}")
    print(f"Engineer platoons: {x1.X}")
else:
    print("No optimal solution found.")
