
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="reconnaissance_troops", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="engineer_platoons", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(3*x0**2 + x1**2 + 4*x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1.36*x0 + 2.16*x1 >= 20, name="mobility_rating_min")
m.addConstr(1.36*x0 + 2.16*x1 <= 41, name="mobility_rating_max")
m.addConstr(4.77*x0 + 3.38*x1 >= 12, name="deployment_weight_min")
m.addConstr(4.77*x0 + 3.38*x1 <= 27, name="deployment_weight_max")
m.addConstr(3.67*x0 + 0.07*x1 >= 18, name="logistics_footprint_min")
m.addConstr(3.67*x0 + 0.07*x1 <= 23, name="logistics_footprint_max")
m.addConstr(0.4*x0 + 5.92*x1 <= 30, name="logistical_capacity_max")
m.addConstr((0.4*x0)**2 + (5.92*x1)**2 >= 20, name="logistical_capacity_squared_min")
m.addConstr((5.77*x0)**2 + (7.12*x1)**2 >= 15, name="fun_factor_squared_min")
m.addConstr((5.77*x0)**2 + (7.12*x1)**2 <= 361, name="fun_factor_squared_max") # corrected to reflect actual upper limit of 19
m.addConstr(2*x0 - 6*x1 >= 0, name="additional_constraint")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Reconnaissance troops: {x0.varValue}")
    print(f"Engineer platoons: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
